/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.authentication;

import com.google.common.base.Strings;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLErrorCode;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLPasswordMessagePacket;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.PostgreSQLLoginResult;

public final class PostgreSQLAuthenticationHandler {
    public static PostgreSQLLoginResult loginWithMd5Password(String username, String databaseName, byte[] md5Salt, PostgreSQLPasswordMessagePacket passwordMessagePacket) {
        String md5Digest = passwordMessagePacket.getMd5Digest();
        Grantee grantee = new Grantee(username, "%");
        if (!Strings.isNullOrEmpty((String)databaseName) && !ProxyContext.getInstance().schemaExists(databaseName)) {
            return new PostgreSQLLoginResult(PostgreSQLErrorCode.INVALID_CATALOG_NAME, String.format("database \"%s\" does not exist", databaseName));
        }
        if (!SQLCheckEngine.check((Grantee)grantee, PostgreSQLAuthenticationHandler.getRules(databaseName))) {
            return new PostgreSQLLoginResult(PostgreSQLErrorCode.INVALID_AUTHORIZATION_SPECIFICATION, String.format("unknown username: %s", username));
        }
        if (!SQLCheckEngine.check((Grantee)grantee, (a, b) -> PostgreSQLAuthenticationHandler.isPasswordRight((ShardingSphereUser)a, (Object[])b), (Object)new Object[]{md5Digest, md5Salt}, PostgreSQLAuthenticationHandler.getRules(databaseName))) {
            return new PostgreSQLLoginResult(PostgreSQLErrorCode.INVALID_PASSWORD, String.format("password authentication failed for user \"%s\"", username));
        }
        return null == databaseName || SQLCheckEngine.check((String)databaseName, PostgreSQLAuthenticationHandler.getRules(databaseName), (Grantee)grantee) ? new PostgreSQLLoginResult(PostgreSQLErrorCode.SUCCESSFUL_COMPLETION, null) : new PostgreSQLLoginResult(PostgreSQLErrorCode.PRIVILEGE_NOT_GRANTED, String.format("Access denied for user '%s' to database '%s'", username, databaseName));
    }

    private static boolean isPasswordRight(ShardingSphereUser user, Object[] args) {
        String md5Digest = (String)args[0];
        byte[] md5Salt = (byte[])args[1];
        String expectedMd5Digest = PostgreSQLAuthenticationHandler.md5Encode(user.getGrantee().getUsername(), user.getPassword(), md5Salt);
        return expectedMd5Digest.equals(md5Digest);
    }

    private static String md5Encode(String username, String password, byte[] md5Salt) {
        String passwordHash = new String(Hex.encodeHex((byte[])DigestUtils.md5((String)(password + username)), (boolean)true));
        MessageDigest messageDigest = DigestUtils.getMd5Digest();
        messageDigest.update(passwordHash.getBytes());
        messageDigest.update(md5Salt);
        return "md5" + new String(Hex.encodeHex((byte[])messageDigest.digest(), (boolean)true));
    }

    private static Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        if (!Strings.isNullOrEmpty((String)databaseName) && ProxyContext.getInstance().schemaExists(databaseName)) {
            result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(databaseName).getRuleMetaData().getRules());
        }
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Generated
    private PostgreSQLAuthenticationHandler() {
    }
}

