/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.postgresql.codec.PostgreSQLPacketCodecEngine;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatementRegistry;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.context.FrontendContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.PostgreSQLAuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLCommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PostgreSQLConnectionContextRegistry;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class PostgreSQLFrontendEngine
implements DatabaseProtocolFrontendEngine {
    private final FrontendContext frontendContext = new FrontendContext(true, false);
    private final AuthenticationEngine authenticationEngine = new PostgreSQLAuthenticationEngine();
    private final CommandExecuteEngine commandExecuteEngine = new PostgreSQLCommandExecuteEngine();
    private final DatabasePacketCodecEngine<PostgreSQLPacket> codecEngine = new PostgreSQLPacketCodecEngine();

    public void release(BackendConnection backendConnection) {
        PostgreSQLBinaryStatementRegistry.getInstance().unregister(backendConnection.getConnectionId());
        PostgreSQLConnectionContextRegistry.getInstance().remove(backendConnection.getConnectionId());
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }

    @Generated
    public FrontendContext getFrontendContext() {
        return this.frontendContext;
    }

    @Generated
    public AuthenticationEngine getAuthenticationEngine() {
        return this.authenticationEngine;
    }

    @Generated
    public CommandExecuteEngine getCommandExecuteEngine() {
        return this.commandExecuteEngine;
    }

    @Generated
    public DatabasePacketCodecEngine<PostgreSQLPacket> getCodecEngine() {
        return this.codecEngine;
    }
}

