/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.connection.dialect;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionWrapper;

public final class OpenGaussXAConnectionWrapper
implements XAConnectionWrapper {
    private static final String BASE_CONNECTION_CLASS = "org.opengauss.core.BaseConnection";
    private static final String PG_XA_CONNECTION_CLASS = "org.opengauss.xa.PGXAConnection";

    @Override
    public XAConnection wrap(XADataSource xaDataSource, Connection connection) {
        Class<?> baseConnectionClass = Class.forName(BASE_CONNECTION_CLASS);
        Object physicalConnection = connection.unwrap(baseConnectionClass);
        Constructor<?> pgXAConnectionConstructor = Class.forName(PG_XA_CONNECTION_CLASS).getConstructor(baseConnectionClass);
        return (XAConnection)pgXAConnectionConstructor.newInstance(physicalConnection);
    }
}

