/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.transaction.core.ResourceDataSource;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.ShardingSphereTransactionManager;
import org.apache.shardingsphere.transaction.xa.jta.datasource.XATransactionDataSource;
import org.apache.shardingsphere.transaction.xa.manager.XATransactionManagerProviderLoader;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManagerProvider;

public final class XAShardingSphereTransactionManager
implements ShardingSphereTransactionManager {
    private final Map<String, XATransactionDataSource> cachedDataSources = new HashMap<String, XATransactionDataSource>();
    private XATransactionManagerProvider xaTransactionManagerProvider;

    public void init(DatabaseType databaseType, Collection<ResourceDataSource> resourceDataSources, TransactionRule transactionRule) {
        this.xaTransactionManagerProvider = XATransactionManagerProviderLoader.getInstance().getXATransactionManagerProvider(transactionRule.getProviderType());
        this.xaTransactionManagerProvider.init();
        resourceDataSources.forEach(each -> this.cachedDataSources.put(each.getOriginalName(), this.newXATransactionDataSource(databaseType, (ResourceDataSource)each)));
    }

    private XATransactionDataSource newXATransactionDataSource(DatabaseType databaseType, ResourceDataSource resourceDataSource) {
        String resourceName = resourceDataSource.getUniqueResourceName();
        DataSource dataSource = resourceDataSource.getDataSource();
        return new XATransactionDataSource(databaseType, resourceName, dataSource, this.xaTransactionManagerProvider);
    }

    public TransactionType getTransactionType() {
        return TransactionType.XA;
    }

    public boolean isInTransaction() {
        return 6 != this.xaTransactionManagerProvider.getTransactionManager().getStatus();
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        try {
            return this.cachedDataSources.get(dataSourceName).getConnection();
        }
        catch (RollbackException | SystemException ex) {
            throw new SQLException(ex);
        }
    }

    public void begin() {
        this.xaTransactionManagerProvider.getTransactionManager().begin();
    }

    public void commit() {
        this.xaTransactionManagerProvider.getTransactionManager().commit();
    }

    public void rollback() {
        this.xaTransactionManagerProvider.getTransactionManager().rollback();
    }

    public void close() throws Exception {
        for (XATransactionDataSource each : this.cachedDataSources.values()) {
            each.close();
        }
        this.cachedDataSources.clear();
        this.xaTransactionManagerProvider.close();
    }
}

