/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.adapter;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSetMetaData;
import org.apache.shardingsphere.driver.jdbc.core.statement.ShardingSpherePreparedStatement;
import org.apache.shardingsphere.driver.jdbc.core.statement.ShardingSphereStatement;
import org.apache.shardingsphere.driver.jdbc.unsupported.AbstractUnsupportedOperationResultSet;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;

public abstract class AbstractResultSetAdapter
extends AbstractUnsupportedOperationResultSet {
    private final List<ResultSet> resultSets;
    private final Statement statement;
    private boolean closed;
    private final ForceExecuteTemplate<ResultSet> forceExecuteTemplate = new ForceExecuteTemplate();
    private final ExecutionContext executionContext;

    protected AbstractResultSetAdapter(List<ResultSet> resultSets, Statement statement, ExecutionContext executionContext) {
        Preconditions.checkArgument((!resultSets.isEmpty() ? 1 : 0) != 0);
        this.resultSets = resultSets;
        this.statement = statement;
        this.executionContext = executionContext;
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        return new ShardingSphereResultSetMetaData(this.resultSets.get(0).getMetaData(), this.getShardingSphereMetaData(), this.executionContext.getSqlStatementContext());
    }

    private ShardingSphereMetaData getShardingSphereMetaData() {
        ShardingSphereConnection connection = this.statement instanceof ShardingSpherePreparedStatement ? ((ShardingSpherePreparedStatement)this.statement).getConnection() : ((ShardingSphereStatement)this.statement).getConnection();
        return connection.getContextManager().getMetaDataContexts().getMetaData(connection.getSchema());
    }

    @Override
    public final int findColumn(String columnLabel) throws SQLException {
        return this.resultSets.get(0).findColumn(columnLabel);
    }

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        this.forceExecuteTemplate.execute(this.resultSets, ResultSet::close);
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.forceExecuteTemplate.execute(this.resultSets, resultSet -> resultSet.setFetchDirection(direction));
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.resultSets.get(0).getFetchDirection();
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.forceExecuteTemplate.execute(this.resultSets, resultSet -> resultSet.setFetchSize(rows));
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.resultSets.get(0).getFetchSize();
    }

    @Override
    public final int getType() throws SQLException {
        return this.resultSets.get(0).getType();
    }

    @Override
    public final int getConcurrency() throws SQLException {
        return this.resultSets.get(0).getConcurrency();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.resultSets.get(0).getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.forceExecuteTemplate.execute(this.resultSets, ResultSet::clearWarnings);
    }

    @Generated
    public List<ResultSet> getResultSets() {
        return this.resultSets;
    }

    @Override
    @Generated
    public Statement getStatement() {
        return this.statement;
    }

    @Generated
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }
}

