/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.schema.loader.SchemaLoader;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilder;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepositoryConfiguration;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;

public final class StandaloneContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ModeConfiguration modeConfig, Map<String, Map<String, DataSource>> dataSourcesMap, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, boolean isOverwrite, Integer port) throws SQLException {
        StandalonePersistRepositoryConfiguration repositoryConfig = null == modeConfig.getRepository() ? new StandalonePersistRepositoryConfiguration("File", new Properties()) : modeConfig.getRepository();
        StandalonePersistRepository repository = (StandalonePersistRepository)TypedSPIRegistry.getRegisteredService(StandalonePersistRepository.class, (String)repositoryConfig.getType(), (Properties)repositoryConfig.getProps());
        MetaDataPersistService metaDataPersistService = new MetaDataPersistService((PersistRepository)repository);
        this.persistConfigurations(metaDataPersistService, dataSourcesMap, schemaRuleConfigs, globalRuleConfigs, props, isOverwrite);
        Collection schemaNames = metaDataPersistService.getSchemaMetaDataService().loadAllNames();
        Map<String, Map<String, DataSource>> standaloneDataSources = this.loadDataSourcesMap(metaDataPersistService, dataSourcesMap, schemaNames);
        Map<String, Collection<RuleConfiguration>> standaloneSchemaRules = this.loadSchemaRules(metaDataPersistService, schemaNames);
        Properties standaloneProps = metaDataPersistService.getPropsService().load();
        Map rules = SchemaRulesBuilder.buildRules(standaloneDataSources, standaloneSchemaRules, (Properties)standaloneProps);
        Map schemas = new SchemaLoader(standaloneDataSources, standaloneSchemaRules, rules, standaloneProps).load();
        MetaDataContexts metaDataContexts = new MetaDataContextsBuilder(standaloneDataSources, standaloneSchemaRules, metaDataPersistService.getGlobalRuleService().load(), schemas, rules, standaloneProps).build(metaDataPersistService);
        TransactionContexts transactionContexts = this.createTransactionContexts(metaDataContexts);
        ContextManager result = new ContextManager();
        result.init(metaDataContexts, transactionContexts);
        return result;
    }

    private void persistConfigurations(MetaDataPersistService metaDataPersistService, Map<String, Map<String, DataSource>> dataSourcesMap, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, boolean overwrite) {
        if (!this.isEmptyLocalConfiguration(dataSourcesMap, schemaRuleConfigs, globalRuleConfigs, props)) {
            metaDataPersistService.persistConfigurations(this.getDataSourceConfigurations(dataSourcesMap), schemaRuleConfigs, globalRuleConfigs, props, overwrite);
        }
    }

    private boolean isEmptyLocalConfiguration(Map<String, Map<String, DataSource>> dataSourcesMap, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props) {
        return this.isEmptyLocalDataSourcesMap(dataSourcesMap) && this.isEmptyLocalSchemaRuleConfigurations(schemaRuleConfigs) && globalRuleConfigs.isEmpty() && props.isEmpty();
    }

    private boolean isEmptyLocalDataSourcesMap(Map<String, Map<String, DataSource>> dataSourcesMap) {
        return dataSourcesMap.entrySet().stream().allMatch(entry -> ((Map)entry.getValue()).isEmpty());
    }

    private boolean isEmptyLocalSchemaRuleConfigurations(Map<String, Collection<RuleConfiguration>> schemaRuleConfigs) {
        return schemaRuleConfigs.entrySet().stream().allMatch(entry -> ((Collection)entry.getValue()).isEmpty());
    }

    private Map<String, Map<String, DataSourceConfiguration>> getDataSourceConfigurations(Map<String, Map<String, DataSource>> dataSourcesMap) {
        LinkedHashMap<String, Map<String, DataSourceConfiguration>> result = new LinkedHashMap<String, Map<String, DataSourceConfiguration>>(dataSourcesMap.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSource>> entry : dataSourcesMap.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.getDataSourceConfigurationMap(entry.getValue()));
        }
        return result;
    }

    private Map<String, Map<String, DataSource>> loadDataSourcesMap(MetaDataPersistService metaDataPersistService, Map<String, Map<String, DataSource>> dataSourcesMap, Collection<String> schemaNames) {
        Map<String, Map<String, DataSourceConfiguration>> loadedDataSourceConfigs = this.loadDataSourceConfigurations(metaDataPersistService, schemaNames);
        Map<String, Map<String, DataSourceConfiguration>> changedDataSourceConfigs = this.getChangedDataSourceConfigurations(dataSourcesMap, loadedDataSourceConfigs);
        LinkedHashMap<String, Map<String, DataSource>> result = new LinkedHashMap<String, Map<String, DataSource>>(dataSourcesMap);
        this.getChangedDataSources(changedDataSourceConfigs).forEach((key, value) -> {
            if (result.containsKey(key)) {
                ((Map)result.get(key)).putAll(value);
            } else {
                result.put((String)key, (Map<String, DataSource>)value);
            }
        });
        return result;
    }

    private Map<String, Map<String, DataSourceConfiguration>> loadDataSourceConfigurations(MetaDataPersistService metaDataPersistService, Collection<String> schemaNames) {
        LinkedHashMap<String, Map<String, DataSourceConfiguration>> result = new LinkedHashMap<String, Map<String, DataSourceConfiguration>>();
        for (String each : schemaNames) {
            result.put(each, metaDataPersistService.getDataSourceService().load(each));
        }
        return result;
    }

    private Map<String, Map<String, DataSourceConfiguration>> getChangedDataSourceConfigurations(Map<String, Map<String, DataSource>> configuredDataSourcesMap, Map<String, Map<String, DataSourceConfiguration>> loadedDataSourceConfigs) {
        if (this.isEmptyLocalDataSourcesMap(configuredDataSourcesMap)) {
            return loadedDataSourceConfigs;
        }
        HashMap<String, Map<String, DataSourceConfiguration>> result = new HashMap<String, Map<String, DataSourceConfiguration>>(loadedDataSourceConfigs.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : loadedDataSourceConfigs.entrySet()) {
            if (configuredDataSourcesMap.containsKey(entry.getKey())) {
                Map<String, DataSourceConfiguration> changedDataSources = this.getChangedDataSourcesConfigurations(configuredDataSourcesMap.get(entry.getKey()), entry.getValue());
                if (changedDataSources.isEmpty()) continue;
                result.put(entry.getKey(), changedDataSources);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Map<String, DataSourceConfiguration> getChangedDataSourcesConfigurations(Map<String, DataSource> dataSourceMap, Map<String, DataSourceConfiguration> loadedDataSourceConfigurationMap) {
        Map dataSourceConfigurationMap = DataSourceConverter.getDataSourceConfigurationMap(dataSourceMap);
        return loadedDataSourceConfigurationMap.entrySet().stream().filter(entry -> !dataSourceConfigurationMap.containsKey(entry.getKey()) || !((DataSourceConfiguration)dataSourceConfigurationMap.get(entry.getKey())).equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Map<String, DataSource>> getChangedDataSources(Map<String, Map<String, DataSourceConfiguration>> changedDataSourceConfigurations) {
        LinkedHashMap<String, Map<String, DataSource>> result = new LinkedHashMap<String, Map<String, DataSource>>(changedDataSourceConfigurations.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : changedDataSourceConfigurations.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.getDataSourceMap(entry.getValue()));
        }
        return result;
    }

    private Map<String, Collection<RuleConfiguration>> loadSchemaRules(MetaDataPersistService metaDataPersistService, Collection<String> schemaNames) {
        return schemaNames.stream().collect(Collectors.toMap(each -> each, each -> metaDataPersistService.getSchemaRuleService().load(each), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private TransactionContexts createTransactionContexts(MetaDataContexts metaDataContexts) {
        HashMap<String, ShardingSphereTransactionManagerEngine> engines = new HashMap<String, ShardingSphereTransactionManagerEngine>(metaDataContexts.getAllSchemaNames().size(), 1.0f);
        TransactionRule transactionRule = this.getTransactionRule(metaDataContexts);
        for (String each : metaDataContexts.getAllSchemaNames()) {
            ShardingSphereTransactionManagerEngine engine = new ShardingSphereTransactionManagerEngine();
            ShardingSphereResource resource = metaDataContexts.getMetaData(each).getResource();
            engine.init(resource.getDatabaseType(), resource.getDataSources(), transactionRule);
            engines.put(each, engine);
        }
        return new TransactionContexts(engines);
    }

    private TransactionRule getTransactionRule(MetaDataContexts metaDataContexts) {
        Optional<TransactionRule> transactionRule = metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    public String getType() {
        return "Standalone";
    }

    static {
        ShardingSphereServiceLoader.register(StandalonePersistRepository.class);
    }
}

