/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.etcd;

import com.google.common.base.Splitter;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Observers;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.etcd.props.EtcdProperties;
import org.apache.shardingsphere.mode.repository.cluster.etcd.props.EtcdPropertyKey;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EtcdRepository
implements ClusterPersistRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdRepository.class);
    private Client client;
    private Properties props = new Properties();
    private EtcdProperties etcdProperties;

    public void init(ClusterPersistRepositoryConfiguration config) {
        this.etcdProperties = new EtcdProperties(this.props);
        this.client = Client.builder().endpoints((Collection)Util.toURIs((Collection)Splitter.on((String)",").trimResults().splitToList((CharSequence)config.getServerLists()))).namespace(ByteSequence.from((String)config.getNamespace(), (Charset)StandardCharsets.UTF_8)).build();
    }

    public String get(String key) {
        List keyValues = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).get()).getKvs();
        return keyValues.isEmpty() ? null : ((KeyValue)keyValues.iterator().next()).getValue().toString(StandardCharsets.UTF_8);
    }

    public List<String> getChildrenKeys(String key) {
        String prefix = key + "/";
        ByteSequence prefixByteSequence = ByteSequence.from((String)prefix, (Charset)StandardCharsets.UTF_8);
        GetOption getOption = GetOption.newBuilder().withPrefix(prefixByteSequence).withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.ASCEND).build();
        List keyValues = ((GetResponse)this.client.getKVClient().get(prefixByteSequence, getOption).get()).getKvs();
        return keyValues.stream().map(e -> this.getSubNodeKeyName(prefix, e.getKey().toString(StandardCharsets.UTF_8))).distinct().collect(Collectors.toList());
    }

    private String getSubNodeKeyName(String prefix, String fullPath) {
        String pathWithoutPrefix = fullPath.substring(prefix.length());
        return pathWithoutPrefix.contains("/") ? pathWithoutPrefix.substring(0, pathWithoutPrefix.indexOf("/")) : pathWithoutPrefix;
    }

    public void persist(String key, String value) {
        this.client.getKVClient().put(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8)).get();
    }

    public void persistEphemeral(String key, String value) {
        long leaseId = ((LeaseGrantResponse)this.client.getLeaseClient().grant(((Long)this.etcdProperties.getValue(EtcdPropertyKey.TIME_TO_LIVE_SECONDS)).longValue()).get()).getID();
        this.client.getLeaseClient().keepAlive(leaseId, Observers.observer(response -> {}));
        this.client.getKVClient().put(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), ByteSequence.from((String)value, (Charset)StandardCharsets.UTF_8), PutOption.newBuilder().withLeaseId(leaseId).build()).get();
    }

    public void delete(String key) {
        this.client.getKVClient().delete(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), DeleteOption.newBuilder().withPrefix(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).build());
    }

    public void watch(String key, DataChangedEventListener dataChangedEventListener) {
        Watch.Listener listener = Watch.listener(response -> {
            for (WatchEvent each : response.getEvents()) {
                DataChangedEvent.Type type = this.getEventChangedType(each);
                if (DataChangedEvent.Type.IGNORED == type) continue;
                dataChangedEventListener.onChange(new DataChangedEvent(each.getKeyValue().getKey().toString(StandardCharsets.UTF_8), each.getKeyValue().getValue().toString(StandardCharsets.UTF_8), type));
            }
        });
        this.client.getWatchClient().watch(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), WatchOption.newBuilder().withPrefix(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).build(), listener);
    }

    private DataChangedEvent.Type getEventChangedType(WatchEvent event) {
        if (1L == event.getKeyValue().getVersion()) {
            return DataChangedEvent.Type.ADDED;
        }
        switch (event.getEventType()) {
            case PUT: {
                return DataChangedEvent.Type.UPDATED;
            }
            case DELETE: {
                return DataChangedEvent.Type.DELETED;
            }
        }
        return DataChangedEvent.Type.IGNORED;
    }

    public boolean tryLock(String key, long time, TimeUnit unit) {
        try {
            long leaseId = ((LeaseGrantResponse)this.client.getLeaseClient().grant(((Long)this.etcdProperties.getValue(EtcdPropertyKey.TIME_TO_LIVE_SECONDS)).longValue()).get()).getID();
            this.client.getLockClient().lock(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8), leaseId).get(time, unit);
            return true;
        }
        catch (Exception ex) {
            log.error("EtcdRepository tryLock error, key:{}, time:{}, unit:{}", new Object[]{key, time, unit, ex});
            return false;
        }
    }

    public void releaseLock(String key) {
        try {
            this.client.getLockClient().unlock(ByteSequence.from((String)key, (Charset)StandardCharsets.UTF_8)).get((Long)this.etcdProperties.getValue(EtcdPropertyKey.CONNECTION_TIMEOUT_SECONDS), TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            log.error("EtcdRepository releaseLock error, key:{}", (Object)key, (Object)ex);
        }
    }

    public void close() {
        this.client.close();
    }

    public String getType() {
        return "etcd";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

