/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.opengauss.wal;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.shardingsphere.scaling.core.config.datasource.StandardJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.BaseLogSequenceNumber;
import org.opengauss.PGProperty;
import org.opengauss.jdbc.PgConnection;
import org.opengauss.replication.LogSequenceNumber;
import org.opengauss.replication.PGReplicationStream;
import org.opengauss.replication.fluent.logical.ChainedLogicalStreamBuilder;
import org.opengauss.util.PSQLException;

public final class OpenGaussLogicalReplication {
    public static final String SLOT_NAME_PREFIX = "sharding_scaling";
    public static final String DECODE_PLUGIN = "mppdb_decoding";
    public static final String DUPLICATE_OBJECT_ERROR_CODE = "42710";

    public Connection createPgConnection(StandardJDBCDataSourceConfiguration jdbcDataSourceConfig) throws SQLException {
        return this.createConnection(jdbcDataSourceConfig);
    }

    private Connection createConnection(StandardJDBCDataSourceConfiguration jdbcDataSourceConfig) throws SQLException {
        Properties props = new Properties();
        PGProperty.USER.set(props, jdbcDataSourceConfig.getHikariConfig().getUsername());
        PGProperty.PASSWORD.set(props, jdbcDataSourceConfig.getHikariConfig().getPassword());
        PGProperty.ASSUME_MIN_SERVER_VERSION.set(props, "9.4");
        PGProperty.REPLICATION.set(props, "database");
        PGProperty.PREFER_QUERY_MODE.set(props, "simple");
        return DriverManager.getConnection(jdbcDataSourceConfig.getHikariConfig().getJdbcUrl(), props);
    }

    public PGReplicationStream createReplicationStream(PgConnection pgConnection, BaseLogSequenceNumber startPosition, String slotName) throws SQLException {
        return ((ChainedLogicalStreamBuilder)((ChainedLogicalStreamBuilder)pgConnection.getReplicationAPI().replicationStream().logical().withSlotName(slotName)).withSlotOption("include-xids", true).withSlotOption("skip-empty-xacts", true).withStartPosition((LogSequenceNumber)startPosition.get())).start();
    }

    public static void createIfNotExists(Connection conn) throws SQLException {
        if (OpenGaussLogicalReplication.isSlotNameExist(conn)) {
            return;
        }
        OpenGaussLogicalReplication.createSlotBySql(conn);
    }

    public static void dropSlot(Connection conn) throws SQLException {
        String sql = String.format("select * from pg_drop_replication_slot('%s')", OpenGaussLogicalReplication.getUniqueSlotName(conn));
        try (CallableStatement cs = conn.prepareCall(sql);){
            cs.execute();
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean isSlotNameExist(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void createSlotBySql(Connection connection) throws SQLException {
        block14: {
            try (PreparedStatement ps = connection.prepareStatement(String.format("SELECT * FROM pg_create_logical_replication_slot('%s', '%s')", OpenGaussLogicalReplication.getUniqueSlotName(connection), DECODE_PLUGIN));){
                ps.execute();
            }
            catch (PSQLException ex) {
                if (DUPLICATE_OBJECT_ERROR_CODE.equals(ex.getSQLState())) break block14;
                throw ex;
            }
        }
    }

    public static String getUniqueSlotName(Connection conn) throws SQLException {
        return String.format("%s_%s", SLOT_NAME_PREFIX, conn.getCatalog());
    }
}

