/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.opengauss.component.checker;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceWrapper;
import org.apache.shardingsphere.scaling.core.common.exception.PrepareFailedException;
import org.apache.shardingsphere.scaling.core.config.JobConfiguration;
import org.apache.shardingsphere.scaling.core.job.preparer.AbstractDataSourcePreparer;
import org.apache.shardingsphere.scaling.core.job.preparer.ActualTableDefinition;
import org.apache.shardingsphere.scaling.core.job.preparer.TableDefinitionSQLType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussDataSourcePreparer
extends AbstractDataSourcePreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussDataSourcePreparer.class);
    private static final String WITH_OF_TABLE_EXTEND = "with (";

    public void prepareTargetTables(JobConfiguration jobConfig) {
        Collection<ActualTableDefinition> actualTableDefinitions;
        try {
            actualTableDefinitions = this.getActualTableDefinitions(jobConfig);
        }
        catch (SQLException ex) {
            throw new PrepareFailedException("get table definitions failed.", (Throwable)ex);
        }
        Map<String, Collection<String>> createLogicTableSQLs = this.getCreateLogicTableSQLs(actualTableDefinitions);
        try (DataSourceWrapper targetDataSource = this.getTargetDataSource(jobConfig);
             Connection targetConnection = targetDataSource.getConnection();){
            for (Map.Entry<String, Collection<String>> entry : createLogicTableSQLs.entrySet()) {
                for (String each : entry.getValue()) {
                    this.executeTargetTableSQL(targetConnection, each);
                }
                log.info("create target table '{}' success", (Object)entry.getKey());
            }
        }
        catch (SQLException ex) {
            throw new PrepareFailedException("prepare target tables failed.", (Throwable)ex);
        }
    }

    private Collection<ActualTableDefinition> getActualTableDefinitions(JobConfiguration jobConfig) throws SQLException {
        ArrayList<ActualTableDefinition> result = new ArrayList<ActualTableDefinition>();
        Map dataSourceTableNamesMap = this.getDataSourceTableNamesMap(jobConfig.getRuleConfig().getSource().unwrap());
        for (Map.Entry entry : dataSourceTableNamesMap.entrySet()) {
            DataSourceWrapper dataSource = new DataSourceWrapper((DataSource)entry.getKey());
            Throwable throwable = null;
            try {
                Connection sourceConnection = dataSource.getConnection();
                Throwable throwable2 = null;
                try {
                    for (Map.Entry tableNameEntry : ((Map)entry.getValue()).entrySet()) {
                        String actualTableName = (String)tableNameEntry.getKey();
                        int oid = this.queryTableOid(sourceConnection, actualTableName);
                        String tableDefinition = this.queryTableDefinition(sourceConnection, oid);
                        String logicTableName = (String)tableNameEntry.getValue();
                        result.add(new ActualTableDefinition(logicTableName, actualTableName, tableDefinition));
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (sourceConnection == null) continue;
                    if (throwable2 != null) {
                        try {
                            sourceConnection.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    sourceConnection.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (dataSource == null) continue;
                if (throwable != null) {
                    try {
                        dataSource.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                dataSource.close();
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private int queryTableOid(Connection sourceConnection, String actualTableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String queryTableDefinition(Connection sourceConnection, int oid) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Collection<String>> getCreateLogicTableSQLs(Collection<ActualTableDefinition> actualTableDefinitions) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (ActualTableDefinition each : actualTableDefinitions) {
            Collection logicTableSQLs = this.splitTableDefinitionToSQLs(each).stream().map(sql -> {
                TableDefinitionSQLType sqlType = this.getTableDefinitionSQLType((String)sql);
                switch (sqlType) {
                    case CREATE_TABLE: {
                        sql = this.addIfNotExistsForCreateTableSQL((String)sql);
                        sql = this.replaceActualTableNameToLogicTableName((String)sql, each.getActualTableName(), each.getLogicTableName());
                        sql = this.skipCreateTableExtendSet((String)sql);
                        return sql;
                    }
                    case ALTER_TABLE: {
                        sql = this.replaceActualTableNameToLogicTableName((String)sql, each.getActualTableName(), each.getLogicTableName());
                        return sql;
                    }
                }
                return "";
            }).filter(sql -> !"".equals(sql)).collect(Collectors.toList());
            result.put(each.getLogicTableName(), logicTableSQLs);
        }
        return result;
    }

    protected String replaceActualTableNameToLogicTableName(String createOrAlterTableSQL, String actualTableName, String logicTableName) {
        StringBuilder logicalTableSQL = new StringBuilder(createOrAlterTableSQL);
        int start;
        while ((start = logicalTableSQL.indexOf(actualTableName)) > 0) {
            int end = start + actualTableName.length();
            logicalTableSQL.replace(start, end, logicTableName);
        }
        return logicalTableSQL.toString();
    }

    private String skipCreateTableExtendSet(String createSQL) {
        String each;
        int curSearch;
        String lowerCreateSQL = createSQL.toLowerCase();
        String[] search = new String[]{WITH_OF_TABLE_EXTEND, ")"};
        ArrayList<Integer> searchPos = new ArrayList<Integer>(2);
        int startPos = 0;
        String[] stringArray = search;
        int n = stringArray.length;
        for (int i = 0; i < n && (curSearch = lowerCreateSQL.indexOf(each = stringArray[i], startPos)) > 0; ++i) {
            searchPos.add(curSearch);
            startPos = curSearch;
        }
        if (searchPos.size() != search.length) {
            return createSQL;
        }
        return createSQL.substring(0, (Integer)searchPos.get(0)) + createSQL.substring((Integer)searchPos.get(1) + 1);
    }
}

