/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.opengauss.component;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.channel.Channel;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingTaskExecuteException;
import org.apache.shardingsphere.scaling.core.common.record.Column;
import org.apache.shardingsphere.scaling.core.common.record.DataRecord;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.config.DumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.StandardJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.executor.AbstractScalingExecutor;
import org.apache.shardingsphere.scaling.core.executor.dumper.IncrementalDumper;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.apache.shardingsphere.scaling.core.util.ThreadUtil;
import org.apache.shardingsphere.scaling.opengauss.wal.OpenGaussLogicalReplication;
import org.apache.shardingsphere.scaling.opengauss.wal.decode.MppdbDecodingPlugin;
import org.apache.shardingsphere.scaling.opengauss.wal.decode.OpenGaussLogSequenceNumber;
import org.apache.shardingsphere.scaling.opengauss.wal.decode.OpenGaussTimestampUtils;
import org.apache.shardingsphere.scaling.postgresql.wal.WalEventConverter;
import org.apache.shardingsphere.scaling.postgresql.wal.WalPosition;
import org.apache.shardingsphere.scaling.postgresql.wal.event.AbstractWalEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.PlaceholderEvent;
import org.opengauss.jdbc.PgConnection;
import org.opengauss.replication.PGReplicationStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussWalDumper
extends AbstractScalingExecutor
implements IncrementalDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussWalDumper.class);
    private final WalPosition walPosition;
    private final DumperConfiguration dumperConfig;
    private final OpenGaussLogicalReplication logicalReplication = new OpenGaussLogicalReplication();
    private final WalEventConverter walEventConverter;
    private String slotName = "sharding_scaling";
    private Channel channel;

    public OpenGaussWalDumper(DumperConfiguration dumperConfig, ScalingPosition<WalPosition> position) {
        this.walPosition = (WalPosition)position;
        if (!StandardJDBCDataSourceConfiguration.class.equals(dumperConfig.getDataSourceConfig().getClass())) {
            throw new UnsupportedOperationException("PostgreSQLWalDumper only support JDBCDataSourceConfiguration");
        }
        this.dumperConfig = dumperConfig;
        this.walEventConverter = new WalEventConverter(dumperConfig);
    }

    public void start() {
        super.start();
        this.dump();
    }

    private PgConnection getReplicationConn() throws SQLException {
        return this.logicalReplication.createPgConnection((StandardJDBCDataSourceConfiguration)this.dumperConfig.getDataSourceConfig()).unwrap(PgConnection.class);
    }

    private MppdbDecodingPlugin initReplication() {
        MppdbDecodingPlugin plugin = null;
        try {
            DataSource dataSource = this.dumperConfig.getDataSourceConfig().toDataSource();
            try (Connection conn = dataSource.getConnection();){
                this.slotName = OpenGaussLogicalReplication.getUniqueSlotName(conn);
                OpenGaussLogicalReplication.createIfNotExists(conn);
                OpenGaussTimestampUtils utils = new OpenGaussTimestampUtils(conn.unwrap(PgConnection.class).getTimestampUtils());
                plugin = new MppdbDecodingPlugin(utils);
            }
        }
        catch (SQLException sqlExp) {
            log.warn("create replication slot failed!");
        }
        return plugin;
    }

    private void dump() {
        MppdbDecodingPlugin decodingPlugin = this.initReplication();
        try (PgConnection pgConnection = this.getReplicationConn();){
            PGReplicationStream stream = this.logicalReplication.createReplicationStream(pgConnection, this.walPosition.getLogSequenceNumber(), this.slotName);
            while (this.isRunning()) {
                ByteBuffer message = stream.readPending();
                if (null == message) {
                    ThreadUtil.sleep((long)10L);
                    continue;
                }
                AbstractWalEvent event = decodingPlugin.decode(message, new OpenGaussLogSequenceNumber(stream.getLastReceiveLSN()));
                Record record = this.walEventConverter.convert(event);
                if (!(event instanceof PlaceholderEvent) && log.isDebugEnabled()) {
                    log.debug("dump, event={}, record={}", (Object)event, (Object)record);
                }
                this.updateRecordOldValue(record);
                this.pushRecord(record);
            }
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("is already active")) {
                return;
            }
            throw new ScalingTaskExecuteException((Throwable)ex);
        }
    }

    private void updateRecordOldValue(Record record) {
        if (!(record instanceof DataRecord)) {
            return;
        }
        DataRecord dataRecord = (DataRecord)record;
        if (!"UPDATE".equals(dataRecord.getType())) {
            return;
        }
        for (Column col : dataRecord.getColumns()) {
            if (!col.isPrimaryKey() || !col.isUpdated()) continue;
            col.setOldValue(col.getValue());
        }
    }

    private void pushRecord(Record record) {
        try {
            this.channel.pushRecord(record);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Generated
    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

