/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.postgresql.wal.decode;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingTaskExecuteException;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.BaseLogSequenceNumber;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.BaseTimestampUtils;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.DecodingException;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.DecodingPlugin;
import org.apache.shardingsphere.scaling.postgresql.wal.event.AbstractRowEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.AbstractWalEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.DeleteRowEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.PlaceholderEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.UpdateRowEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.WriteRowEvent;

public final class TestDecodingPlugin
implements DecodingPlugin {
    private final BaseTimestampUtils timestampUtils;

    @Override
    public AbstractWalEvent decode(ByteBuffer data, BaseLogSequenceNumber logSequenceNumber) {
        String eventType = this.readEventType(data);
        AbstractWalEvent result = "table".equals(eventType) ? this.readTableEvent(data) : new PlaceholderEvent();
        result.setLogSequenceNumber(logSequenceNumber);
        return result;
    }

    private String readEventType(ByteBuffer data) {
        return this.readNextSegment(data);
    }

    private AbstractRowEvent readTableEvent(ByteBuffer data) {
        AbstractRowEvent result;
        String rowEventType;
        String tableName = this.readTableName(data);
        switch (rowEventType = this.readRowEventType(data)) {
            case "INSERT": {
                result = this.readWriteRowEvent(data);
                break;
            }
            case "UPDATE": {
                result = this.readUpdateRowEvent(data);
                break;
            }
            case "DELETE": {
                result = this.readDeleteRowEvent(data);
                break;
            }
            default: {
                throw new ScalingTaskExecuteException("");
            }
        }
        String[] tableMetaData = tableName.split("\\.");
        result.setSchemaName(tableMetaData[0]);
        result.setTableName(tableMetaData[1].substring(0, tableMetaData[1].length() - 1));
        return result;
    }

    private AbstractRowEvent readWriteRowEvent(ByteBuffer data) {
        WriteRowEvent result = new WriteRowEvent();
        LinkedList<Object> afterColumns = new LinkedList<Object>();
        while (data.hasRemaining()) {
            afterColumns.add(this.readColumn(data));
        }
        result.setAfterRow(afterColumns);
        return result;
    }

    private AbstractRowEvent readUpdateRowEvent(ByteBuffer data) {
        UpdateRowEvent result = new UpdateRowEvent();
        LinkedList<Object> afterColumns = new LinkedList<Object>();
        while (data.hasRemaining()) {
            afterColumns.add(this.readColumn(data));
        }
        result.setAfterRow(afterColumns);
        return result;
    }

    private AbstractRowEvent readDeleteRowEvent(ByteBuffer data) {
        DeleteRowEvent result = new DeleteRowEvent();
        LinkedList<Object> afterColumns = new LinkedList<Object>();
        while (data.hasRemaining()) {
            afterColumns.add(this.readColumn(data));
        }
        result.setPrimaryKeys(afterColumns);
        return result;
    }

    private String readTableName(ByteBuffer data) {
        return this.readNextSegment(data);
    }

    private String readRowEventType(ByteBuffer data) {
        String result = this.readNextSegment(data);
        return result.substring(0, result.length() - 1);
    }

    private Object readColumn(ByteBuffer data) {
        String columnName = this.readColumnName(data);
        String columnType = this.readColumnType(data);
        data.get();
        return this.readColumnData(data, columnType);
    }

    private String readColumnName(ByteBuffer data) {
        StringBuilder eventType = new StringBuilder();
        while (data.hasRemaining()) {
            char c = (char)data.get();
            if ('[' == c) {
                return eventType.toString();
            }
            eventType.append(c);
        }
        return eventType.toString();
    }

    private String readColumnType(ByteBuffer data) {
        StringBuilder eventType = new StringBuilder();
        while (data.hasRemaining()) {
            char c = (char)data.get();
            if (']' == c) {
                return eventType.toString();
            }
            eventType.append(c);
        }
        return eventType.toString();
    }

    private Object readColumnData(ByteBuffer data, String columnType) {
        if (columnType.startsWith("numeric")) {
            return new BigDecimal(this.readNextSegment(data));
        }
        if (columnType.startsWith("bit") || columnType.startsWith("bit varying")) {
            return this.readNextSegment(data);
        }
        switch (columnType) {
            case "smallint": {
                return Short.parseShort(this.readNextSegment(data));
            }
            case "integer": {
                return Integer.parseInt(this.readNextSegment(data));
            }
            case "bigint": {
                return Long.parseLong(this.readNextSegment(data));
            }
            case "real": {
                return Float.valueOf(Float.parseFloat(this.readNextSegment(data)));
            }
            case "double precision": {
                return Double.parseDouble(this.readNextSegment(data));
            }
            case "boolean": {
                return Boolean.parseBoolean(this.readNextSegment(data));
            }
            case "time without time zone": {
                try {
                    return this.timestampUtils.toTime(null, this.readNextString(data));
                }
                catch (SQLException ex) {
                    throw new DecodingException(ex);
                }
            }
            case "date": {
                return Date.valueOf(this.readNextString(data));
            }
            case "timestamp without time zone": {
                try {
                    return this.timestampUtils.toTimestamp(null, this.readNextString(data));
                }
                catch (SQLException ex) {
                    throw new DecodingException(ex);
                }
            }
            case "bytea": {
                return this.decodeHex(this.readNextString(data).substring(2));
            }
        }
        return this.readNextString(data);
    }

    private String readNextSegment(ByteBuffer data) {
        StringBuilder eventType = new StringBuilder();
        while (data.hasRemaining()) {
            char c = (char)data.get();
            if (' ' == c) {
                return eventType.toString();
            }
            eventType.append(c);
        }
        return eventType.toString();
    }

    private String readNextString(ByteBuffer data) {
        StringBuilder result = new StringBuilder();
        data.get();
        while (data.hasRemaining()) {
            char c = (char)data.get();
            if ('\'' == c) {
                if (!data.hasRemaining()) {
                    return result.toString();
                }
                char c2 = (char)data.get();
                if (' ' == c2) {
                    return result.toString();
                }
                if ('\'' != c2) {
                    throw new ScalingTaskExecuteException("Read character varying data unexpected exception");
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    private byte[] decodeHex(String hexString) {
        int dataLength = hexString.length();
        if (0 != (dataLength & 1)) {
            throw new IllegalArgumentException(String.format("Illegal hex data %s", hexString));
        }
        if (0 == dataLength) {
            return new byte[0];
        }
        byte[] result = new byte[dataLength >>> 1];
        for (int i = 0; i < dataLength; i += 2) {
            result[i >>> 1] = this.decodeHexByte(hexString, i);
        }
        return result;
    }

    private byte decodeHexByte(String hexString, int index) {
        int firstHexChar = Character.digit(hexString.charAt(index), 16);
        int secondHexChar = Character.digit(hexString.charAt(index + 1), 16);
        if (-1 == firstHexChar || -1 == secondHexChar) {
            throw new IllegalArgumentException(String.format("Illegal hex byte '%s' in index %d", hexString, index));
        }
        return (byte)((firstHexChar << 4) + secondHexChar);
    }

    @Generated
    public TestDecodingPlugin(BaseTimestampUtils timestampUtils) {
        this.timestampUtils = timestampUtils;
    }
}

