/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.postgresql.wal;

import java.util.List;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceFactory;
import org.apache.shardingsphere.scaling.core.common.datasource.MetaDataManager;
import org.apache.shardingsphere.scaling.core.common.record.Column;
import org.apache.shardingsphere.scaling.core.common.record.DataRecord;
import org.apache.shardingsphere.scaling.core.common.record.PlaceholderRecord;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.config.DumperConfiguration;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.apache.shardingsphere.scaling.postgresql.wal.WalPosition;
import org.apache.shardingsphere.scaling.postgresql.wal.event.AbstractRowEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.AbstractWalEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.DeleteRowEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.PlaceholderEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.UpdateRowEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.WriteRowEvent;

public final class WalEventConverter {
    private final DumperConfiguration dumperConfig;
    private final DatabaseType databaseType;
    private final MetaDataManager metaDataManager;

    public WalEventConverter(DumperConfiguration dumperConfig) {
        this.dumperConfig = dumperConfig;
        this.databaseType = dumperConfig.getDataSourceConfig().getDatabaseType();
        this.metaDataManager = new MetaDataManager((DataSource)new DataSourceFactory().newInstance(dumperConfig.getDataSourceConfig()));
    }

    public Record convert(AbstractWalEvent event) {
        if (this.filter(event)) {
            return this.createPlaceholderRecord(event);
        }
        if (event instanceof WriteRowEvent) {
            return this.handleWriteRowsEvent((WriteRowEvent)event);
        }
        if (event instanceof UpdateRowEvent) {
            return this.handleUpdateRowsEvent((UpdateRowEvent)event);
        }
        if (event instanceof DeleteRowEvent) {
            return this.handleDeleteRowsEvent((DeleteRowEvent)event);
        }
        if (event instanceof PlaceholderEvent) {
            return this.createPlaceholderRecord(event);
        }
        throw new UnsupportedOperationException("");
    }

    private boolean filter(AbstractWalEvent event) {
        if (this.isRowEvent(event)) {
            AbstractRowEvent rowEvent = (AbstractRowEvent)event;
            return !this.dumperConfig.getTableNameMap().containsKey(rowEvent.getTableName());
        }
        return false;
    }

    private boolean isRowEvent(AbstractWalEvent event) {
        return event instanceof WriteRowEvent || event instanceof UpdateRowEvent || event instanceof DeleteRowEvent;
    }

    private PlaceholderRecord createPlaceholderRecord(AbstractWalEvent event) {
        return new PlaceholderRecord((ScalingPosition)new WalPosition(event.getLogSequenceNumber()));
    }

    private DataRecord handleWriteRowsEvent(WriteRowEvent writeRowEvent) {
        DataRecord result = this.createDataRecord(writeRowEvent, writeRowEvent.getAfterRow().size());
        result.setType("INSERT");
        this.putColumnsIntoDataRecord(result, this.metaDataManager.getTableMetaData(writeRowEvent.getTableName(), this.databaseType), writeRowEvent.getAfterRow());
        return result;
    }

    private DataRecord handleUpdateRowsEvent(UpdateRowEvent updateRowEvent) {
        DataRecord result = this.createDataRecord(updateRowEvent, updateRowEvent.getAfterRow().size());
        result.setType("UPDATE");
        this.putColumnsIntoDataRecord(result, this.metaDataManager.getTableMetaData(updateRowEvent.getTableName(), this.databaseType), updateRowEvent.getAfterRow());
        return result;
    }

    private DataRecord handleDeleteRowsEvent(DeleteRowEvent event) {
        DataRecord result = this.createDataRecord(event, event.getPrimaryKeys().size());
        result.setType("DELETE");
        List primaryKeyColumns = this.metaDataManager.getTableMetaData(event.getTableName(), this.databaseType).getPrimaryKeyColumns();
        for (int i = 0; i < event.getPrimaryKeys().size(); ++i) {
            result.addColumn(new Column((String)primaryKeyColumns.get(i), event.getPrimaryKeys().get(i), true, true));
        }
        return result;
    }

    private DataRecord createDataRecord(AbstractRowEvent rowsEvent, int columnCount) {
        DataRecord result = new DataRecord((ScalingPosition)new WalPosition(rowsEvent.getLogSequenceNumber()), columnCount);
        result.setTableName((String)this.dumperConfig.getTableNameMap().get(rowsEvent.getTableName()));
        return result;
    }

    private void putColumnsIntoDataRecord(DataRecord dataRecord, TableMetaData tableMetaData, List<Object> values) {
        for (int i = 0; i < values.size(); ++i) {
            dataRecord.addColumn(new Column(tableMetaData.getColumnMetaData(i).getName(), values.get(i), true, tableMetaData.isPrimaryKey(i)));
        }
    }
}

