/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.postgresql.wal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.shardingsphere.scaling.core.config.datasource.StandardJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.BaseLogSequenceNumber;
import org.postgresql.PGConnection;
import org.postgresql.PGProperty;
import org.postgresql.replication.LogSequenceNumber;
import org.postgresql.replication.PGReplicationStream;
import org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;

public final class LogicalReplication {
    public Connection createPgConnection(StandardJDBCDataSourceConfiguration jdbcDataSourceConfig) throws SQLException {
        return this.createConnection(jdbcDataSourceConfig);
    }

    private Connection createConnection(StandardJDBCDataSourceConfiguration jdbcDataSourceConfig) throws SQLException {
        Properties props = new Properties();
        PGProperty.USER.set(props, jdbcDataSourceConfig.getHikariConfig().getUsername());
        PGProperty.PASSWORD.set(props, jdbcDataSourceConfig.getHikariConfig().getPassword());
        PGProperty.ASSUME_MIN_SERVER_VERSION.set(props, "9.6");
        PGProperty.REPLICATION.set(props, "database");
        PGProperty.PREFER_QUERY_MODE.set(props, "simple");
        return DriverManager.getConnection(jdbcDataSourceConfig.getHikariConfig().getJdbcUrl(), props);
    }

    public PGReplicationStream createReplicationStream(Connection pgConnection, String slotName, BaseLogSequenceNumber startPosition) throws SQLException {
        return ((ChainedLogicalStreamBuilder)((ChainedLogicalStreamBuilder)pgConnection.unwrap(PGConnection.class).getReplicationAPI().replicationStream().logical().withStartPosition((LogSequenceNumber)startPosition.get())).withSlotName(slotName)).withSlotOption("include-xids", true).withSlotOption("skip-empty-xacts", true).start();
    }
}

