/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.postgresql.component.checker;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.shardingsphere.scaling.core.common.exception.PrepareFailedException;
import org.apache.shardingsphere.scaling.core.common.sqlbuilder.ScalingSQLBuilder;
import org.apache.shardingsphere.scaling.core.job.check.source.AbstractDataSourceChecker;
import org.apache.shardingsphere.scaling.postgresql.component.PostgreSQLScalingSQLBuilder;

public final class PostgreSQLDataSourceChecker
extends AbstractDataSourceChecker {
    public void checkPrivilege(Collection<? extends DataSource> dataSources) {
        try {
            for (DataSource dataSource : dataSources) {
                Connection connection = dataSource.getConnection();
                Throwable throwable = null;
                try {
                    ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), null, "%", new String[]{"TABLE"});
                    Throwable throwable2 = null;
                    try {
                        if (!resultSet.next()) {
                            throw new PrepareFailedException("No resultSet find in the source data source.");
                        }
                        String tableName = resultSet.getString(3);
                        this.checkTableExisted(tableName, connection);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new PrepareFailedException("Data sources privilege check failed.", (Throwable)ex);
        }
    }

    private void checkTableExisted(String tableName, Connection connection) throws SQLException {
        String sql = "SELECT * FROM " + tableName + " LIMIT 1";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.executeQuery();
        }
    }

    public void checkVariable(Collection<? extends DataSource> dataSources) {
    }

    protected ScalingSQLBuilder getSQLBuilder() {
        return new PostgreSQLScalingSQLBuilder(new HashMap<String, Set<String>>());
    }
}

