/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.postgresql.component;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.scaling.core.common.channel.Channel;
import org.apache.shardingsphere.scaling.core.common.exception.ScalingTaskExecuteException;
import org.apache.shardingsphere.scaling.core.common.record.Record;
import org.apache.shardingsphere.scaling.core.config.DumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.StandardJDBCDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.executor.AbstractScalingExecutor;
import org.apache.shardingsphere.scaling.core.executor.dumper.IncrementalDumper;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;
import org.apache.shardingsphere.scaling.core.util.ThreadUtil;
import org.apache.shardingsphere.scaling.postgresql.wal.LogicalReplication;
import org.apache.shardingsphere.scaling.postgresql.wal.WalEventConverter;
import org.apache.shardingsphere.scaling.postgresql.wal.WalPosition;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.PostgreSQLLogSequenceNumber;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.PostgreSQLTimestampUtils;
import org.apache.shardingsphere.scaling.postgresql.wal.decode.TestDecodingPlugin;
import org.apache.shardingsphere.scaling.postgresql.wal.event.AbstractWalEvent;
import org.apache.shardingsphere.scaling.postgresql.wal.event.PlaceholderEvent;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.replication.PGReplicationStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgreSQLWalDumper
extends AbstractScalingExecutor
implements IncrementalDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLWalDumper.class);
    private final WalPosition walPosition;
    private final DumperConfiguration dumperConfig;
    private final LogicalReplication logicalReplication = new LogicalReplication();
    private final WalEventConverter walEventConverter;
    private Channel channel;

    public PostgreSQLWalDumper(DumperConfiguration dumperConfig, ScalingPosition<WalPosition> position) {
        this.walPosition = (WalPosition)position;
        if (!StandardJDBCDataSourceConfiguration.class.equals(dumperConfig.getDataSourceConfig().getClass())) {
            throw new UnsupportedOperationException("PostgreSQLWalDumper only support JDBCDataSourceConfiguration");
        }
        this.dumperConfig = dumperConfig;
        this.walEventConverter = new WalEventConverter(dumperConfig);
    }

    public void start() {
        super.start();
        this.dump();
    }

    private void dump() {
        try (Connection pgConnection = this.logicalReplication.createPgConnection((StandardJDBCDataSourceConfiguration)this.dumperConfig.getDataSourceConfig());
             PGReplicationStream stream = this.logicalReplication.createReplicationStream(pgConnection, "sharding_scaling", this.walPosition.getLogSequenceNumber());){
            PostgreSQLTimestampUtils utils = new PostgreSQLTimestampUtils(pgConnection.unwrap(PgConnection.class).getTimestampUtils());
            TestDecodingPlugin decodingPlugin = new TestDecodingPlugin(utils);
            while (this.isRunning()) {
                ByteBuffer message = stream.readPending();
                if (null == message) {
                    ThreadUtil.sleep((long)10L);
                    continue;
                }
                AbstractWalEvent event = decodingPlugin.decode(message, new PostgreSQLLogSequenceNumber(stream.getLastReceiveLSN()));
                Record record = this.walEventConverter.convert(event);
                if (!(event instanceof PlaceholderEvent) && log.isDebugEnabled()) {
                    log.debug("dump, event={}, record={}", (Object)event, (Object)record);
                }
                this.pushRecord(record);
            }
        }
        catch (SQLException ex) {
            throw new ScalingTaskExecuteException((Throwable)ex);
        }
    }

    private void pushRecord(Record record) {
        try {
            this.channel.pushRecord(record);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Generated
    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

