/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.postgresql.component;

import java.util.Map;
import java.util.Set;
import org.apache.shardingsphere.scaling.core.common.record.Column;
import org.apache.shardingsphere.scaling.core.common.record.DataRecord;
import org.apache.shardingsphere.scaling.core.common.record.RecordUtil;
import org.apache.shardingsphere.scaling.core.common.sqlbuilder.AbstractScalingSQLBuilder;

public final class PostgreSQLScalingSQLBuilder
extends AbstractScalingSQLBuilder {
    public PostgreSQLScalingSQLBuilder(Map<String, Set<String>> shardingColumnsMap) {
        super(shardingColumnsMap);
    }

    public String getLeftIdentifierQuoteString() {
        return "\"";
    }

    public String getRightIdentifierQuoteString() {
        return "\"";
    }

    public String buildInsertSQL(DataRecord dataRecord) {
        return super.buildInsertSQL(dataRecord) + this.buildConflictSQL(dataRecord);
    }

    private String buildConflictSQL(DataRecord dataRecord) {
        StringBuilder result = new StringBuilder(" ON CONFLICT (");
        for (Column each : RecordUtil.extractPrimaryColumns((DataRecord)dataRecord)) {
            result.append(each.getName()).append(",");
        }
        result.setLength(result.length() - 1);
        result.append(") DO NOTHING");
        return result.toString();
    }
}

