/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.rule;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.algorithm.config.AlgorithmProvidedDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryDataSourceRule;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryType;
import org.apache.shardingsphere.infra.aware.DataSourceNameAware;
import org.apache.shardingsphere.infra.aware.DataSourceNameAwareFactory;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class DatabaseDiscoveryRule
implements SchemaRule,
DataSourceContainedRule,
StatusContainedRule,
ExportableRule {
    private final Map<String, DatabaseDiscoveryType> discoveryTypes;
    private final Map<String, DatabaseDiscoveryDataSourceRule> dataSourceRules;

    public DatabaseDiscoveryRule(DatabaseDiscoveryRuleConfiguration config, String schemaName, Map<String, DataSource> dataSourceMap) {
        this(config.getDataSources(), DatabaseDiscoveryRule.getDiscoveryTypes(config.getDiscoveryTypes()), schemaName, dataSourceMap);
    }

    public DatabaseDiscoveryRule(AlgorithmProvidedDatabaseDiscoveryRuleConfiguration config, String schemaName, Map<String, DataSource> dataSourceMap) {
        this(config.getDataSources(), config.getDiscoveryTypes(), schemaName, dataSourceMap);
    }

    private DatabaseDiscoveryRule(Collection<DatabaseDiscoveryDataSourceRuleConfiguration> dataSourceRuleConfigs, Map<String, DatabaseDiscoveryType> discoveryTypes, String schemaName, Map<String, DataSource> dataSourceMap) {
        this.checkDataSourcesArguments(dataSourceRuleConfigs, dataSourceMap);
        this.discoveryTypes = discoveryTypes;
        this.dataSourceRules = this.getDataSourceRules(dataSourceRuleConfigs);
        this.startMonitor(schemaName, dataSourceMap);
        this.initAware();
    }

    private static Map<String, DatabaseDiscoveryType> getDiscoveryTypes(Map<String, ShardingSphereAlgorithmConfiguration> discoveryTypesConfig) {
        LinkedHashMap<String, DatabaseDiscoveryType> result = new LinkedHashMap<String, DatabaseDiscoveryType>(discoveryTypesConfig.size(), 1.0f);
        for (Map.Entry<String, ShardingSphereAlgorithmConfiguration> entry : discoveryTypesConfig.entrySet()) {
            result.put(entry.getKey(), (DatabaseDiscoveryType)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)((TypedSPIConfiguration)entry.getValue()), DatabaseDiscoveryType.class));
        }
        return result;
    }

    private void checkDataSourcesArguments(Collection<DatabaseDiscoveryDataSourceRuleConfiguration> dataSources, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((!dataSources.isEmpty() ? 1 : 0) != 0, (Object)"Database discovery rules can not be empty.");
        Preconditions.checkArgument((null != dataSourceMap && !dataSourceMap.isEmpty() ? 1 : 0) != 0, (Object)"Data sources cannot be empty.");
    }

    private Map<String, DatabaseDiscoveryDataSourceRule> getDataSourceRules(Collection<DatabaseDiscoveryDataSourceRuleConfiguration> dataSources) {
        HashMap<String, DatabaseDiscoveryDataSourceRule> result = new HashMap<String, DatabaseDiscoveryDataSourceRule>(dataSources.size(), 1.0f);
        for (DatabaseDiscoveryDataSourceRuleConfiguration each : dataSources) {
            this.checkDatabaseDiscoveryDataSourceRuleConfigurationArguments(each);
            result.put(each.getName(), new DatabaseDiscoveryDataSourceRule(each, this.discoveryTypes.get(each.getDiscoveryTypeName())));
        }
        return result;
    }

    private void checkDatabaseDiscoveryDataSourceRuleConfigurationArguments(DatabaseDiscoveryDataSourceRuleConfiguration dataSourceRuleConfig) {
        Preconditions.checkNotNull((Object)dataSourceRuleConfig.getDiscoveryTypeName(), (String)"Discovery type cannot be null of rule name `%s`.", (Object)dataSourceRuleConfig.getName());
        Preconditions.checkArgument((boolean)this.discoveryTypes.containsKey(dataSourceRuleConfig.getDiscoveryTypeName()), (String)"Can not find discovery type of rule name `%s`.", (Object)dataSourceRuleConfig.getName());
    }

    private void startMonitor(String schemaName, Map<String, DataSource> dataSourceMap) {
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            String groupName = entry.getKey();
            DatabaseDiscoveryDataSourceRule dataSourceRule = entry.getValue();
            DatabaseDiscoveryType databaseDiscoveryType = dataSourceRule.getDatabaseDiscoveryType();
            HashMap<String, DataSource> originalDataSourceMap = new HashMap<String, DataSource>(dataSourceMap);
            Collection<String> disabledDataSourceNames = dataSourceRule.getDisabledDataSourceNames();
            String primaryDataSourceName = dataSourceRule.getPrimaryDataSourceName();
            databaseDiscoveryType.updatePrimaryDataSource(schemaName, originalDataSourceMap, disabledDataSourceNames, groupName, primaryDataSourceName);
            dataSourceRule.updatePrimaryDataSourceName(databaseDiscoveryType.getPrimaryDataSource());
            databaseDiscoveryType.updateMemberState(schemaName, originalDataSourceMap, disabledDataSourceNames);
            try {
                databaseDiscoveryType.checkDatabaseDiscoveryConfiguration(schemaName, dataSourceMap);
                databaseDiscoveryType.startPeriodicalUpdate(schemaName, originalDataSourceMap, disabledDataSourceNames, groupName, primaryDataSourceName);
            }
            catch (SQLException ex) {
                throw new ShardingSphereException((Exception)ex);
            }
        }
    }

    private void initAware() {
        DataSourceNameAwareFactory.getInstance().getDataSourceNameAware().ifPresent(optional -> optional.setRule((ShardingSphereRule)this));
    }

    public DatabaseDiscoveryDataSourceRule getSingleDataSourceRule() {
        return this.dataSourceRules.values().iterator().next();
    }

    public Optional<DatabaseDiscoveryDataSourceRule> findDataSourceRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRules.get(dataSourceName));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            result.putAll(entry.getValue().getDataSourceMapper());
        }
        return result;
    }

    public void updateStatus(DataSourceStatusChangedEvent event) {
        block4: {
            block3: {
                if (!(event instanceof DataSourceNameDisabledEvent)) break block3;
                for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                    if (((DataSourceNameDisabledEvent)event).isDisabled()) {
                        entry.getValue().disableDataSource(((DataSourceNameDisabledEvent)event).getDataSourceName());
                        continue;
                    }
                    entry.getValue().enableDataSource(((DataSourceNameDisabledEvent)event).getDataSourceName());
                }
                break block4;
            }
            if (!(event instanceof PrimaryDataSourceChangedEvent)) break block4;
            for (Map.Entry<String, DatabaseDiscoveryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                if (!entry.getValue().getName().equals(((PrimaryDataSourceChangedEvent)event).getGroupName())) continue;
                entry.getValue().updatePrimaryDataSourceName(((PrimaryDataSourceChangedEvent)event).getDataSourceName());
            }
        }
    }

    public Map<String, Object> export() {
        HashMap<String, Object> result = new HashMap<String, Object>(1, 1.0f);
        result.put("primary_data_source_key", this.exportPrimaryDataSourceMap());
        return result;
    }

    private Map<String, String> exportPrimaryDataSourceMap() {
        HashMap<String, String> result = new HashMap<String, String>(this.dataSourceRules.size(), 1.0f);
        this.dataSourceRules.forEach((name, dataSourceRule) -> result.put(dataSourceRule.getName(), dataSourceRule.getPrimaryDataSourceName()));
        return result;
    }

    public String getType() {
        return DatabaseDiscoveryRule.class.getSimpleName();
    }

    @Generated
    public Map<String, DatabaseDiscoveryDataSourceRule> getDataSourceRules() {
        return this.dataSourceRules;
    }

    static {
        ShardingSphereServiceLoader.register(DatabaseDiscoveryType.class);
        ShardingSphereServiceLoader.register(DataSourceNameAware.class);
    }
}

