/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.mysql.component.column.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.scaling.mysql.component.column.metadata.MySQLColumnMetaData;

public final class MySQLColumnMetaDataLoader {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";
    private final Map<String, List<MySQLColumnMetaData>> columnMetaDataMap = new HashMap<String, List<MySQLColumnMetaData>>();
    private final DataSource dataSource;

    public List<MySQLColumnMetaData> load(String tableNamePattern) {
        if (!this.columnMetaDataMap.containsKey(tableNamePattern)) {
            try (Connection connection = this.dataSource.getConnection();){
                this.columnMetaDataMap.put(tableNamePattern, this.load0(connection, tableNamePattern));
            }
            catch (SQLException ex) {
                throw new RuntimeException(String.format("Load metaData for table %s failed", tableNamePattern), ex);
            }
        }
        return this.columnMetaDataMap.get(tableNamePattern);
    }

    private List<MySQLColumnMetaData> load0(Connection connection, String tableNamePattern) throws SQLException {
        LinkedList<MySQLColumnMetaData> result = new LinkedList<MySQLColumnMetaData>();
        Collection<String> primaryKeys = this.loadPrimaryKeys(connection, tableNamePattern);
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> columnTypeNames = new ArrayList<String>();
        ArrayList<Boolean> isPrimaryKeys = new ArrayList<Boolean>();
        try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), connection.getSchema(), tableNamePattern, "%");){
            while (resultSet.next()) {
                String tableName = resultSet.getString(TABLE_NAME);
                if (!Objects.equals(tableNamePattern, tableName)) continue;
                String columnName = resultSet.getString(COLUMN_NAME);
                columnTypeNames.add(resultSet.getString(TYPE_NAME));
                isPrimaryKeys.add(primaryKeys.contains(columnName));
                columnNames.add(columnName);
            }
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            result.add(new MySQLColumnMetaData((String)columnNames.get(i), (String)columnTypeNames.get(i), (Boolean)isPrimaryKeys.get(i)));
        }
        return result;
    }

    private Collection<String> loadPrimaryKeys(Connection connection, String table) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), connection.getSchema(), table);){
            while (resultSet.next()) {
                result.add(resultSet.getString(COLUMN_NAME));
            }
        }
        return result;
    }

    @Generated
    public MySQLColumnMetaDataLoader(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

