/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.mysql.component.checker;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.shardingsphere.scaling.core.common.exception.PrepareFailedException;
import org.apache.shardingsphere.scaling.core.job.check.source.AbstractDataSourceChecker;
import org.apache.shardingsphere.scaling.mysql.component.MySQLScalingSQLBuilder;

public final class MySQLDataSourceChecker
extends AbstractDataSourceChecker {
    private static final String SHOW_GRANTS_SQL = "SHOW GRANTS";
    private static final String[][] REQUIRED_PRIVILEGES = new String[][]{{"ALL PRIVILEGES", "ON *.*"}, {"REPLICATION SLAVE", "REPLICATION CLIENT", "ON *.*"}};
    private static final String SHOW_VARIABLES_SQL = "SHOW VARIABLES LIKE ?";
    private static final Map<String, String> REQUIRED_VARIABLES = new HashMap<String, String>(3, 1.0f);

    public void checkPrivilege(Collection<? extends DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            this.checkPrivilege(dataSource);
        }
    }

    private void checkPrivilege(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(SHOW_GRANTS_SQL);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (true) {
                if (resultSet.next()) {
                    String privilege = resultSet.getString(1).toUpperCase();
                    if (!this.matchPrivileges(privilege)) continue;
                    return;
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            throw new PrepareFailedException("Source data source check privileges failed.", (Throwable)ex);
        }
        throw new PrepareFailedException("Source data source is lack of REPLICATION SLAVE, REPLICATION CLIENT ON *.* privileges.");
    }

    private boolean matchPrivileges(String privilege) {
        return Arrays.stream(REQUIRED_PRIVILEGES).anyMatch(each -> Arrays.stream(each).allMatch(privilege::contains));
    }

    public void checkVariable(Collection<? extends DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            this.checkVariable(dataSource);
        }
    }

    private void checkVariable(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            for (Map.Entry<String, String> entry : REQUIRED_VARIABLES.entrySet()) {
                this.checkVariable(connection, entry.getKey(), entry.getValue());
            }
        }
        catch (SQLException ex) {
            throw new PrepareFailedException("Source data source check variables failed.", (Throwable)ex);
        }
    }

    private void checkVariable(Connection connection, String key, String toBeCheckedValue) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(SHOW_VARIABLES_SQL);){
            preparedStatement.setString(1, "%" + key);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                resultSet.next();
                String actualValue = resultSet.getString(2);
                if (!toBeCheckedValue.equalsIgnoreCase(actualValue)) {
                    throw new PrepareFailedException(String.format("Source data source required `%s = %s`, now is `%s`", key, toBeCheckedValue, actualValue));
                }
            }
        }
    }

    protected MySQLScalingSQLBuilder getSQLBuilder() {
        return new MySQLScalingSQLBuilder(new HashMap<String, Set<String>>());
    }

    static {
        REQUIRED_VARIABLES.put("LOG_BIN", "ON");
        REQUIRED_VARIABLES.put("BINLOG_FORMAT", "ROW");
        REQUIRED_VARIABLES.put("BINLOG_ROW_IMAGE", "FULL");
    }
}

