/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.mysql.component.checker;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.scaling.core.api.DataCalculateParameter;
import org.apache.shardingsphere.scaling.core.api.impl.AbstractSingleTableDataCalculator;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceWrapper;
import org.apache.shardingsphere.scaling.core.common.exception.DataCheckFailException;
import org.apache.shardingsphere.scaling.mysql.component.MySQLScalingSQLBuilder;

public final class DefaultMySQLSingleTableDataCalculator
extends AbstractSingleTableDataCalculator {
    private static final String DATABASE_TYPE = new MySQLDatabaseType().getName();

    public String getAlgorithmType() {
        return "DEFAULT";
    }

    public String getDatabaseType() {
        return DATABASE_TYPE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object dataCalculate(DataCalculateParameter dataCalculateParameter) {
        String logicTableName = dataCalculateParameter.getLogicTableName();
        MySQLScalingSQLBuilder scalingSQLBuilder = new MySQLScalingSQLBuilder(new HashMap<String, Set<String>>());
        try (DataSourceWrapper dataSource = this.getDataSource(dataCalculateParameter.getDataSourceConfig());){
            List list = dataCalculateParameter.getColumnNames().stream().map(each -> {
                String sql = scalingSQLBuilder.buildSumCrc32SQL(logicTableName, (String)each);
                return this.sumCrc32((DataSource)dataSource, sql);
            }).collect(Collectors.toList());
            return list;
        }
        catch (SQLException ex) {
            throw new DataCheckFailException(String.format("table %s data check failed.", logicTableName), (Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private long sumCrc32(DataSource dataSource, String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

