/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.mysql.component;

import java.util.Map;
import java.util.Set;
import org.apache.shardingsphere.scaling.core.common.record.Column;
import org.apache.shardingsphere.scaling.core.common.record.DataRecord;
import org.apache.shardingsphere.scaling.core.common.sqlbuilder.AbstractScalingSQLBuilder;

public final class MySQLScalingSQLBuilder
extends AbstractScalingSQLBuilder {
    public MySQLScalingSQLBuilder(Map<String, Set<String>> shardingColumnsMap) {
        super(shardingColumnsMap);
    }

    public String getLeftIdentifierQuoteString() {
        return "`";
    }

    public String getRightIdentifierQuoteString() {
        return "`";
    }

    public String buildInsertSQL(DataRecord dataRecord) {
        return super.buildInsertSQL(dataRecord) + this.buildDuplicateUpdateSQL(dataRecord);
    }

    private String buildDuplicateUpdateSQL(DataRecord dataRecord) {
        StringBuilder result = new StringBuilder(" ON DUPLICATE KEY UPDATE ");
        for (int i = 0; i < dataRecord.getColumnCount(); ++i) {
            Column column = dataRecord.getColumn(i);
            if (column.isPrimaryKey() || this.isShardingColumn(this.getShardingColumnsMap(), dataRecord.getTableName(), column.getName())) continue;
            result.append((CharSequence)this.quote(column.getName())).append("=VALUES(").append((CharSequence)this.quote(column.getName())).append("),");
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    private boolean isShardingColumn(Map<String, Set<String>> shardingColumnsMap, String tableName, String columnName) {
        return shardingColumnsMap.containsKey(tableName) && shardingColumnsMap.get(tableName).contains(columnName);
    }

    public String buildSumCrc32SQL(String tableName, String column) {
        return String.format("SELECT SUM(CRC32(%s)) AS checksum FROM %s", this.quote(column), this.quote(tableName));
    }
}

