/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.mysql.component;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.shardingsphere.scaling.core.common.datasource.DataSourceManager;
import org.apache.shardingsphere.scaling.core.config.InventoryDumperConfiguration;
import org.apache.shardingsphere.scaling.core.config.datasource.ScalingDataSourceConfiguration;
import org.apache.shardingsphere.scaling.core.executor.dumper.AbstractInventoryDumper;
import org.apache.shardingsphere.scaling.core.util.JDBCUtil;

public final class MySQLInventoryDumper
extends AbstractInventoryDumper {
    public MySQLInventoryDumper(InventoryDumperConfiguration inventoryDumperConfig, DataSourceManager dataSourceManager) {
        super(inventoryDumperConfig, dataSourceManager);
        JDBCUtil.appendJDBCParameter((ScalingDataSourceConfiguration)inventoryDumperConfig.getDataSourceConfig(), (Map)ImmutableMap.builder().put((Object)"yearIsDateType", (Object)"false").build());
    }

    public Object readValue(ResultSet resultSet, int index) throws SQLException {
        if (this.isDateTimeValue(resultSet.getMetaData().getColumnType(index))) {
            return resultSet.getString(index);
        }
        return resultSet.getObject(index);
    }

    private boolean isDateTimeValue(int columnType) {
        return 92 == columnType || 91 == columnType || 93 == columnType;
    }

    protected PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        PreparedStatement result = connection.prepareStatement(sql, 1003, 1007);
        result.setFetchSize(Integer.MIN_VALUE);
        return result;
    }
}

