/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.mysql.binlog;

import lombok.Generated;
import org.apache.shardingsphere.scaling.core.job.position.ScalingPosition;

public final class BinlogPosition
implements ScalingPosition<BinlogPosition> {
    private final String filename;
    private final long position;
    private long serverId;

    public int compareTo(BinlogPosition position) {
        if (null == position) {
            return 1;
        }
        return Long.compare(this.toLong(), position.toLong());
    }

    private long toLong() {
        return Long.parseLong(this.filename.substring(this.filename.lastIndexOf(46) + 1)) << 32 | this.position;
    }

    public String toString() {
        return String.format("%s#%d", this.filename, this.position);
    }

    @Generated
    public BinlogPosition(String filename, long position) {
        this.filename = filename;
        this.position = position;
    }

    @Generated
    public BinlogPosition(String filename, long position, long serverId) {
        this.filename = filename;
        this.position = position;
        this.serverId = serverId;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public long getPosition() {
        return this.position;
    }

    @Generated
    public long getServerId() {
        return this.serverId;
    }

    @Generated
    public void setServerId(long serverId) {
        this.serverId = serverId;
    }
}

