/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.engine;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.engine.result.RouteSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteUnit;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.impl.RouteSQLBuilder;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class RouteSQLRewriteEngine {
    public RouteSQLRewriteResult rewrite(SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        LinkedHashMap<RouteUnit, SQLRewriteUnit> result = new LinkedHashMap<RouteUnit, SQLRewriteUnit>(routeContext.getRouteUnits().size(), 1.0f);
        for (RouteUnit each : routeContext.getRouteUnits()) {
            result.put(each, new SQLRewriteUnit(new RouteSQLBuilder(sqlRewriteContext, each).toSQL(), this.getParameters(sqlRewriteContext.getParameterBuilder(), routeContext, each)));
        }
        return new RouteSQLRewriteResult(result);
    }

    private List<Object> getParameters(ParameterBuilder parameterBuilder, RouteContext routeContext, RouteUnit routeUnit) {
        if (parameterBuilder instanceof StandardParameterBuilder) {
            return parameterBuilder.getParameters();
        }
        return routeContext.getOriginalDataNodes().isEmpty() ? ((GroupedParameterBuilder)parameterBuilder).getParameters() : this.buildRouteParameters((GroupedParameterBuilder)parameterBuilder, routeContext, routeUnit);
    }

    private List<Object> buildRouteParameters(GroupedParameterBuilder parameterBuilder, RouteContext routeContext, RouteUnit routeUnit) {
        LinkedList<Object> result = new LinkedList<Object>();
        int count = 0;
        for (Collection each : routeContext.getOriginalDataNodes()) {
            if (this.isInSameDataNode(each, routeUnit)) {
                result.addAll(parameterBuilder.getParameters(count));
            }
            ++count;
        }
        result.addAll(parameterBuilder.getGenericParameterBuilder().getParameters());
        return result;
    }

    private boolean isInSameDataNode(Collection<DataNode> dataNodes, RouteUnit routeUnit) {
        if (dataNodes.isEmpty()) {
            return true;
        }
        for (DataNode each : dataNodes) {
            if (!routeUnit.findTableMapper(each.getDataSourceName(), each.getTableName()).isPresent()) continue;
            return true;
        }
        return false;
    }
}

