/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLNewParametersBoundFlag;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLBinaryStatement;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLBinaryStatementParameterType;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLBinaryStatementRegistry;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLNullBitmap;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLComStmtExecutePacket
extends MySQLCommandPacket {
    private static final int ITERATION_COUNT = 1;
    private static final int NULL_BITMAP_OFFSET = 0;
    private final int statementId;
    private final MySQLBinaryStatement binaryStatement;
    private final int flags;
    private final MySQLNullBitmap nullBitmap;
    private final MySQLNewParametersBoundFlag newParametersBoundFlag;
    private final String sql;
    private final List<Object> parameters;

    public MySQLComStmtExecutePacket(MySQLPacketPayload payload) throws SQLException {
        super(MySQLCommandPacketType.COM_STMT_EXECUTE);
        this.statementId = payload.readInt4();
        this.binaryStatement = MySQLBinaryStatementRegistry.getInstance().get(this.statementId);
        this.flags = payload.readInt1();
        Preconditions.checkArgument((1 == payload.readInt4() ? 1 : 0) != 0);
        int parameterCount = this.binaryStatement.getParameterCount();
        this.sql = this.binaryStatement.getSql();
        if (parameterCount > 0) {
            this.nullBitmap = new MySQLNullBitmap(parameterCount, 0);
            for (int i = 0; i < this.nullBitmap.getNullBitmap().length; ++i) {
                this.nullBitmap.getNullBitmap()[i] = payload.readInt1();
            }
            this.newParametersBoundFlag = MySQLNewParametersBoundFlag.valueOf(payload.readInt1());
            if (MySQLNewParametersBoundFlag.PARAMETER_TYPE_EXIST == this.newParametersBoundFlag) {
                this.binaryStatement.setParameterTypes(this.getParameterTypes(payload, parameterCount));
            }
            this.parameters = this.getParameters(payload, parameterCount);
        } else {
            this.nullBitmap = null;
            this.newParametersBoundFlag = null;
            this.parameters = Collections.emptyList();
        }
    }

    private List<MySQLBinaryStatementParameterType> getParameterTypes(MySQLPacketPayload payload, int parameterCount) {
        ArrayList<MySQLBinaryStatementParameterType> result = new ArrayList<MySQLBinaryStatementParameterType>(parameterCount);
        for (int parameterIndex = 0; parameterIndex < parameterCount; ++parameterIndex) {
            MySQLBinaryColumnType columnType = MySQLBinaryColumnType.valueOf(payload.readInt1());
            int unsignedFlag = payload.readInt1();
            result.add(new MySQLBinaryStatementParameterType(columnType, unsignedFlag));
        }
        return result;
    }

    private List<Object> getParameters(MySQLPacketPayload payload, int parameterCount) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(parameterCount);
        for (int parameterIndex = 0; parameterIndex < parameterCount; ++parameterIndex) {
            MySQLBinaryProtocolValue binaryProtocolValue = MySQLBinaryProtocolValueFactory.getBinaryProtocolValue(this.binaryStatement.getParameterTypes().get(parameterIndex).getColumnType());
            result.add(this.nullBitmap.isNullParameter(parameterIndex) ? null : binaryProtocolValue.read(payload));
        }
        return result;
    }

    @Override
    public void doWrite(MySQLPacketPayload payload) {
        payload.writeInt4(this.statementId);
        payload.writeInt1(this.flags);
        payload.writeInt4(1);
        if (this.binaryStatement.getParameterCount() > 0) {
            for (int each : this.nullBitmap.getNullBitmap()) {
                payload.writeInt1(each);
            }
            payload.writeInt1(this.newParametersBoundFlag.getValue());
            int count = 0;
            for (Object each : this.parameters) {
                MySQLBinaryStatementParameterType parameterType = this.binaryStatement.getParameterTypes().get(count);
                payload.writeInt1(parameterType.getColumnType().getValue());
                payload.writeInt1(parameterType.getUnsignedFlag());
                payload.writeStringLenenc(null == each ? "" : each.toString());
                ++count;
            }
        }
    }

    @Generated
    public String toString() {
        return "MySQLComStmtExecutePacket(sql=" + this.getSql() + ", parameters=" + this.getParameters() + ")";
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }
}

