/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.binary.BinaryCell;
import org.apache.shardingsphere.db.protocol.binary.BinaryRow;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.MySQLNullBitmap;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLBinaryResultSetRowPacket
implements MySQLPacket {
    private static final int PACKET_HEADER = 0;
    private static final int NULL_BITMAP_OFFSET = 2;
    private final int sequenceId;
    private final BinaryRow row;

    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(0);
        this.writeNullBitmap(payload);
        this.writeValues(payload);
    }

    private void writeNullBitmap(MySQLPacketPayload payload) {
        for (int each : this.getNullBitmap().getNullBitmap()) {
            payload.writeInt1(each);
        }
    }

    private MySQLNullBitmap getNullBitmap() {
        MySQLNullBitmap result = new MySQLNullBitmap(this.row.getCells().size(), 2);
        int index = 0;
        for (BinaryCell each : this.row.getCells()) {
            if (null == each.getData()) {
                result.setNullBit(index);
            }
            ++index;
        }
        return result;
    }

    private void writeValues(MySQLPacketPayload payload) {
        for (BinaryCell each : this.row.getCells()) {
            Object data = each.getData();
            if (null == data) continue;
            MySQLBinaryProtocolValueFactory.getBinaryProtocolValue(each.getColumnType()).write(payload, data);
        }
    }

    @Generated
    public MySQLBinaryResultSetRowPacket(int sequenceId, BinaryRow row) {
        this.sequenceId = sequenceId;
        this.row = row;
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }
}

