/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.MySQLBinaryStatement;

public final class MySQLBinaryStatementRegistry {
    private static final MySQLBinaryStatementRegistry INSTANCE = new MySQLBinaryStatementRegistry();
    private final ConcurrentMap<String, Integer> statementIdAssigner = new ConcurrentHashMap<String, Integer>(65535, 1.0f);
    private final ConcurrentMap<Integer, MySQLBinaryStatement> binaryStatements = new ConcurrentHashMap<Integer, MySQLBinaryStatement>(65535, 1.0f);
    private final AtomicInteger sequence = new AtomicInteger();

    public static MySQLBinaryStatementRegistry getInstance() {
        return INSTANCE;
    }

    public synchronized int register(String sql, int parameterCount) {
        Integer result = (Integer)this.statementIdAssigner.get(sql);
        if (null != result) {
            return result;
        }
        result = this.sequence.incrementAndGet();
        this.statementIdAssigner.putIfAbsent(sql, result);
        this.binaryStatements.putIfAbsent(result, new MySQLBinaryStatement(sql, parameterCount));
        return result;
    }

    public MySQLBinaryStatement get(int statementId) {
        return (MySQLBinaryStatement)this.binaryStatements.get(statementId);
    }

    public synchronized void unregister(int statementId) {
        if (this.binaryStatements.containsKey(statementId)) {
            this.statementIdAssigner.remove(((MySQLBinaryStatement)this.binaryStatements.get(statementId)).getSql());
            this.binaryStatements.remove(statementId);
        }
    }
}

