/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.constant;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.error.SQLErrorCode;

public enum MySQLServerErrorCode implements SQLErrorCode
{
    ER_DBACCESS_DENIED_ERROR(1044, "42000", "Access denied for user '%s'@'%s' to database '%s'"),
    ER_ACCESS_DENIED_ERROR(1045, "28000", "Access denied for user '%s'@'%s' (using password: %s)"),
    ER_NO_DB_ERROR(1046, "3D000", "No database selected"),
    ER_BAD_DB_ERROR(1049, "42000", "Unknown database '%s'"),
    ER_INTERNAL_ERROR(1815, "HY000", "Internal error: %s"),
    ER_UNSUPPORTED_PS(1295, "HY000", "This command is not supported in the prepared statement protocol yet"),
    ER_DB_CREATE_EXISTS_ERROR(1007, "HY000", "Can't create database '%s'; database exists"),
    ER_DB_DROP_EXISTS_ERROR(1008, "HY000", "Can't drop database '%s'; database doesn't exist"),
    ER_TABLE_EXISTS_ERROR(1050, "42S01", "Table '%s' already exists"),
    ER_NO_SUCH_TABLE(1146, "42S02", "Table '%s' doesn't exist"),
    ER_NOT_SUPPORTED_YET(1235, "42000", "This version of ShardingSphere-Proxy doesn't yet support this SQL. '%s'"),
    ER_SP_DOES_NOT_EXIST(1305, "42000", "Message: Datasource or ShardingSphere rule does not exist"),
    ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE(3176, "HY000", "Please do not modify the %s table with an XA transaction. This is an internal system table used to store GTIDs for committed transactions. Although modifying it can lead to an inconsistent GTID state, if necessary you can modify it with a non-XA transaction.");

    private final int errorCode;
    private final String sqlState;
    private final String errorMessage;

    @Generated
    private MySQLServerErrorCode(int errorCode, String sqlState, String errorMessage) {
        this.errorCode = errorCode;
        this.sqlState = sqlState;
        this.errorMessage = errorMessage;
    }

    @Generated
    public int getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getSqlState() {
        return this.sqlState;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

