/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.user;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import lombok.Generated;

public final class Grantee {
    private final String username;
    private final String hostname;

    public boolean equals(Object obj) {
        if (obj instanceof Grantee) {
            Grantee grantee = (Grantee)obj;
            return grantee.username.equalsIgnoreCase(this.username) && this.isPermittedHost(grantee);
        }
        return false;
    }

    private boolean isPermittedHost(Grantee grantee) {
        return grantee.hostname.equalsIgnoreCase(this.hostname) || this.isUnlimitedHost();
    }

    private boolean isUnlimitedHost() {
        return Strings.isNullOrEmpty((String)this.hostname) || "%".equals(this.hostname);
    }

    public String getHostname() {
        return Strings.isNullOrEmpty((String)this.hostname) ? "%" : this.hostname;
    }

    public int hashCode() {
        return this.isUnlimitedHost() ? Objects.hashCode((Object[])new Object[]{this.username.toUpperCase()}) : Objects.hashCode((Object[])new Object[]{this.username.toUpperCase(), this.hostname.toUpperCase()});
    }

    public String toString() {
        return String.format("%s@%s", this.username, this.hostname);
    }

    @Generated
    public Grantee(String username, String hostname) {
        this.username = username;
        this.hostname = hostname;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }
}

