/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.TableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class SchemaBuilder {
    public static ShardingSphereSchema buildKernelSchema(Collection<TableMetaData> tableMetaDataList, Collection<ShardingSphereRule> rules) {
        return SchemaBuilder.buildSchema(tableMetaDataList, each -> TableMetaDataBuilder.decorateKernelTableMetaData(each, rules));
    }

    public static ShardingSphereSchema buildFederationSchema(Collection<TableMetaData> tableMetaDataList, Collection<ShardingSphereRule> rules) {
        return SchemaBuilder.buildSchema(tableMetaDataList, each -> TableMetaDataBuilder.decorateFederationTableMetaData(each, rules));
    }

    private static ShardingSphereSchema buildSchema(Collection<TableMetaData> tableMetaDataList, Function<TableMetaData, TableMetaData> mapper) {
        Map tableMetaDataMap = tableMetaDataList.stream().map(mapper).collect(Collectors.toMap(TableMetaData::getName, Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return new ShardingSphereSchema(tableMetaDataMap);
    }

    @Generated
    private SchemaBuilder() {
    }
}

