/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.UnrecognizedDatabaseURLException;

public final class SQLServerDataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = 1433;
    private final String hostName;
    private final int port;
    private final String catalog;
    private final String schema;
    private final Pattern pattern = Pattern.compile("jdbc:(microsoft:)?sqlserver://([\\w\\-\\.]+):?([0-9]*);\\S*(DatabaseName|database)=([\\w\\-\\.]+);?", 2);

    public SQLServerDataSourceMetaData(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (!matcher.find()) {
            throw new UnrecognizedDatabaseURLException(url, this.pattern.pattern());
        }
        this.hostName = matcher.group(2);
        this.port = Strings.isNullOrEmpty((String)matcher.group(3)) ? 1433 : Integer.parseInt(matcher.group(3));
        this.catalog = matcher.group(5);
        this.schema = null;
    }

    @Override
    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }
}

