/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.UnrecognizedDatabaseURLException;

public final class OracleDataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = 1521;
    private static final int THIN_MATCH_GROUP_COUNT = 5;
    private final String hostName;
    private final int port;
    private final String catalog;
    private final String schema;
    private final Pattern thinUrlPattern = Pattern.compile("jdbc:oracle:(thin|oci|kprb):@(//)?([\\w\\-\\.]+):?([0-9]*)[:/]([\\w\\-]+)", 2);
    private final Pattern connectDescriptorUrlPattern = Pattern.compile("jdbc:oracle:(thin|oci|kprb):@[(\\w\\s=)]+HOST\\s*=\\s*(\\d+(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}).*PORT\\s*=\\s*(\\d+).*SERVICE_NAME\\s*=\\s*(\\w+)\\)");

    public OracleDataSourceMetaData(String url, String username) {
        List<Matcher> matcherList = Arrays.asList(this.thinUrlPattern.matcher(url), this.connectDescriptorUrlPattern.matcher(url));
        Optional<Matcher> matcherOptional = matcherList.stream().filter(Matcher::find).findAny();
        if (!matcherOptional.isPresent()) {
            throw new UnrecognizedDatabaseURLException(url, this.thinUrlPattern.pattern());
        }
        Matcher matcher = matcherOptional.get();
        int groupCount = matcher.groupCount();
        if (5 == groupCount) {
            this.hostName = matcher.group(3);
            this.port = Strings.isNullOrEmpty((String)matcher.group(4)) ? 1521 : Integer.parseInt(matcher.group(4));
            this.catalog = matcher.group(5);
            this.schema = username;
        } else {
            this.hostName = matcher.group(2);
            this.port = Integer.parseInt(matcher.group(7));
            this.catalog = matcher.group(8);
            this.schema = username;
        }
    }

    @Override
    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public Pattern getThinUrlPattern() {
        return this.thinUrlPattern;
    }

    @Generated
    public Pattern getConnectDescriptorUrlPattern() {
        return this.connectDescriptorUrlPattern;
    }
}

