/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.strategy.type.standard;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ListShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.RangeShardingConditionValue;
import org.apache.shardingsphere.sharding.route.engine.condition.value.ShardingConditionValue;
import org.apache.shardingsphere.sharding.route.strategy.ShardingStrategy;

public final class StandardShardingStrategy
implements ShardingStrategy {
    private final String shardingColumn;
    private final StandardShardingAlgorithm<?> shardingAlgorithm;

    public StandardShardingStrategy(String shardingColumn, StandardShardingAlgorithm<?> shardingAlgorithm) {
        Preconditions.checkNotNull((Object)shardingColumn, (Object)"Sharding column cannot be null.");
        Preconditions.checkNotNull(shardingAlgorithm, (Object)"sharding algorithm cannot be null.");
        this.shardingColumn = shardingColumn;
        this.shardingAlgorithm = shardingAlgorithm;
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingConditionValue> shardingConditionValues, ConfigurationProperties props) {
        ShardingConditionValue shardingConditionValue = shardingConditionValues.iterator().next();
        Collection<String> shardingResult = shardingConditionValue instanceof ListShardingConditionValue ? this.doSharding(availableTargetNames, (ListShardingConditionValue)shardingConditionValue) : this.doSharding(availableTargetNames, (RangeShardingConditionValue)shardingConditionValue);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, ListShardingConditionValue<?> shardingValue) {
        LinkedList<String> result = new LinkedList<String>();
        for (Comparable each : shardingValue.getValues()) {
            String target = this.shardingAlgorithm.doSharding(availableTargetNames, new PreciseShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), each));
            if (null != target && availableTargetNames.contains(target)) {
                result.add(target);
                continue;
            }
            if (null == target || availableTargetNames.contains(target)) continue;
            throw new ShardingSphereException(String.format("Route table %s does not exist, available actual table: %s", target, availableTargetNames), new Object[0]);
        }
        return result;
    }

    private Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingConditionValue<?> shardingValue) {
        return this.shardingAlgorithm.doSharding(availableTargetNames, new RangeShardingValue(shardingValue.getTableName(), shardingValue.getColumnName(), shardingValue.getValueRange()));
    }

    @Override
    public Collection<String> getShardingColumns() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.add(this.shardingColumn);
        return result;
    }

    @Generated
    public StandardShardingAlgorithm<?> getShardingAlgorithm() {
        return this.shardingAlgorithm;
    }
}

