/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.broadcast;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.complex.ShardingCartesianRoutingEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;

public final class ShardingTableBroadcastRoutingEngine
implements ShardingRouteEngine {
    private final ShardingSphereSchema schema;
    private final SQLStatementContext<?> sqlStatementContext;
    private final Collection<String> shardingRuleTableNames;

    @Override
    public RouteContext route(ShardingRule shardingRule) {
        RouteContext result = new RouteContext();
        Collection<String> logicTableNames = this.getLogicTableNames();
        if (logicTableNames.isEmpty()) {
            result.getRouteUnits().addAll(this.getBroadcastTableRouteUnits(shardingRule, ""));
            return result;
        }
        if (logicTableNames.size() > 1 && shardingRule.isAllBindingTables(logicTableNames)) {
            result.getRouteUnits().addAll(this.getBindingTableRouteUnits(shardingRule, logicTableNames));
        } else {
            Collection<RouteContext> routeContexts = this.getRouteContexts(shardingRule, logicTableNames);
            RouteContext routeContext = new ShardingCartesianRoutingEngine(routeContexts).route(shardingRule);
            result.getOriginalDataNodes().addAll(routeContext.getOriginalDataNodes());
            result.getRouteUnits().addAll(routeContext.getRouteUnits());
        }
        return result;
    }

    private Collection<RouteContext> getRouteContexts(ShardingRule shardingRule, Collection<String> logicTableNames) {
        LinkedList<RouteContext> result = new LinkedList<RouteContext>();
        for (String each : logicTableNames) {
            RouteContext routeContext = new RouteContext();
            if (shardingRule.getBroadcastTables().contains(each)) {
                routeContext.getRouteUnits().addAll(this.getBroadcastTableRouteUnits(shardingRule, each));
            } else if (shardingRule.findTableRule(each).isPresent()) {
                routeContext.getRouteUnits().addAll(this.getAllRouteUnits(shardingRule, each));
            }
            if (routeContext.getRouteUnits().isEmpty()) continue;
            result.add(routeContext);
        }
        return result;
    }

    private Collection<RouteUnit> getBindingTableRouteUnits(ShardingRule shardingRule, Collection<String> tableNames) {
        String primaryTableName = tableNames.iterator().next();
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        TableRule tableRule = shardingRule.getTableRule(primaryTableName);
        for (DataNode each : tableRule.getActualDataNodes()) {
            result.add(new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), this.getBindingTableMappers(shardingRule, each, primaryTableName, tableNames)));
        }
        return result;
    }

    private Collection<RouteMapper> getBindingTableMappers(ShardingRule shardingRule, DataNode dataNode, String primaryTableName, Collection<String> tableNames) {
        LinkedList<RouteMapper> result = new LinkedList<RouteMapper>();
        result.add(new RouteMapper(primaryTableName, dataNode.getTableName()));
        result.addAll(shardingRule.getLogicAndActualTablesFromBindingTable(dataNode.getDataSourceName(), primaryTableName, dataNode.getTableName(), tableNames).entrySet().stream().map(each -> new RouteMapper((String)each.getKey(), (String)each.getValue())).collect(Collectors.toList()));
        return result;
    }

    private Collection<String> getLogicTableNames() {
        if (!this.shardingRuleTableNames.isEmpty()) {
            return this.shardingRuleTableNames;
        }
        return this.sqlStatementContext instanceof IndexAvailable ? this.getTableNamesFromMetaData(((IndexAvailable)this.sqlStatementContext).getIndexes()) : Collections.emptyList();
    }

    private Collection<String> getTableNamesFromMetaData(Collection<IndexSegment> indexes) {
        LinkedList<String> result = new LinkedList<String>();
        for (IndexSegment each : indexes) {
            this.findLogicTableNameFromMetaData(each.getIdentifier().getValue()).ifPresent(result::add);
        }
        return result;
    }

    private Optional<String> findLogicTableNameFromMetaData(String logicIndexName) {
        for (String each : this.schema.getAllTableNames()) {
            if (!this.schema.get(each).getIndexes().containsKey(logicIndexName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private Collection<RouteUnit> getBroadcastTableRouteUnits(ShardingRule shardingRule, String broadcastTableName) {
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        for (String each : shardingRule.getDataSourceNames()) {
            result.add(new RouteUnit(new RouteMapper(each, each), Collections.singletonList(new RouteMapper(broadcastTableName, broadcastTableName))));
        }
        return result;
    }

    private Collection<RouteUnit> getAllRouteUnits(ShardingRule shardingRule, String logicTableName) {
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        TableRule tableRule = shardingRule.getTableRule(logicTableName);
        for (DataNode each : tableRule.getActualDataNodes()) {
            result.add(new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), Collections.singletonList(new RouteMapper(logicTableName, each.getTableName()))));
        }
        return result;
    }

    @Generated
    public ShardingTableBroadcastRoutingEngine(ShardingSphereSchema schema, SQLStatementContext<?> sqlStatementContext, Collection<String> shardingRuleTableNames) {
        this.schema = schema;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingRuleTableNames = shardingRuleTableNames;
    }
}

