/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rewrite.context;

import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.rewrite.parameter.ShardingParameterRewriterBuilder;
import org.apache.shardingsphere.sharding.rewrite.token.pojo.ShardingTokenGenerateBuilder;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingSQLRewriteContextDecorator
implements SQLRewriteContextDecorator<ShardingRule> {
    public void decorate(ShardingRule shardingRule, ConfigurationProperties props, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        if (routeContext.isFederated()) {
            return;
        }
        for (ParameterRewriter each : new ShardingParameterRewriterBuilder(shardingRule, routeContext).getParameterRewriters(sqlRewriteContext.getSchema())) {
            if (sqlRewriteContext.getParameters().isEmpty() || !each.isNeedRewrite(sqlRewriteContext.getSqlStatementContext())) continue;
            each.rewrite(sqlRewriteContext.getParameterBuilder(), sqlRewriteContext.getSqlStatementContext(), sqlRewriteContext.getParameters());
        }
        sqlRewriteContext.addSQLTokenGenerators(new ShardingTokenGenerateBuilder(shardingRule, routeContext).getSQLTokenGenerators());
    }

    public int getOrder() {
        return -10;
    }

    public Class<ShardingRule> getTypeClass() {
        return ShardingRule.class;
    }
}

