/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.groupby;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.sharding.merge.dql.orderby.CompareUtil;

public final class GroupByRowComparator
implements Comparator<MemoryQueryResultRow> {
    private final SelectStatementContext selectStatementContext;
    private final List<Boolean> valueCaseSensitive;

    @Override
    public int compare(MemoryQueryResultRow o1, MemoryQueryResultRow o2) {
        if (!this.selectStatementContext.getOrderByContext().getItems().isEmpty()) {
            return this.compare(o1, o2, this.selectStatementContext.getOrderByContext().getItems());
        }
        return this.compare(o1, o2, this.selectStatementContext.getGroupByContext().getItems());
    }

    private int compare(MemoryQueryResultRow o1, MemoryQueryResultRow o2, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Object orderValue1 = o1.getCell(each.getIndex());
            Preconditions.checkState((null == orderValue1 || orderValue1 instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            Object orderValue2 = o2.getCell(each.getIndex());
            Preconditions.checkState((null == orderValue2 || orderValue2 instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            int result = CompareUtil.compareTo((Comparable)orderValue1, (Comparable)orderValue2, each.getSegment().getOrderDirection(), each.getSegment().getNullOrderDirection(), this.valueCaseSensitive.get(each.getIndex()));
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    @Generated
    public GroupByRowComparator(SelectStatementContext selectStatementContext, List<Boolean> valueCaseSensitive) {
        this.selectStatementContext = selectStatementContext;
        this.valueCaseSensitive = valueCaseSensitive;
    }
}

