/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.classbased;

import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public final class ClassBasedShardingAlgorithmFactory {
    public static <T extends ShardingAlgorithm> T newInstance(String shardingAlgorithmClassName, Class<T> superShardingAlgorithmClass) {
        Class<?> result = Class.forName(shardingAlgorithmClassName);
        if (!superShardingAlgorithmClass.isAssignableFrom(result)) {
            throw new ShardingSphereException("Class %s should be implement %s", new Object[]{shardingAlgorithmClassName, superShardingAlgorithmClass.getName()});
        }
        ShardingAlgorithm instance = (ShardingAlgorithm)result.newInstance();
        instance.init();
        return (T)instance;
    }

    @Generated
    private ClassBasedShardingAlgorithmFactory() {
    }
}

