/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.classbased;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.sharding.algorithm.sharding.classbased.ClassBasedShardingAlgorithmFactory;
import org.apache.shardingsphere.sharding.algorithm.sharding.classbased.ClassBasedShardingAlgorithmStrategyType;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.complex.ComplexKeysShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.hint.HintShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class ClassBasedShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ComplexKeysShardingAlgorithm<Comparable<?>>,
HintShardingAlgorithm<Comparable<?>> {
    private static final String STRATEGY_KEY = "strategy";
    private static final String ALGORITHM_CLASS_NAME_KEY = "algorithmClassName";
    private StandardShardingAlgorithm standardShardingAlgorithm;
    private ComplexKeysShardingAlgorithm complexKeysShardingAlgorithm;
    private HintShardingAlgorithm hintShardingAlgorithm;
    private ClassBasedShardingAlgorithmStrategyType strategy;
    private String algorithmClassName;
    private Properties props = new Properties();

    public void init() {
        String strategyKey = this.props.getProperty(STRATEGY_KEY);
        Preconditions.checkNotNull((Object)strategyKey, (String)"The props`%s` cannot be null when uses class based sharding strategy.", (Object)STRATEGY_KEY);
        this.strategy = ClassBasedShardingAlgorithmStrategyType.valueOf(strategyKey.toUpperCase().trim());
        this.algorithmClassName = this.props.getProperty(ALGORITHM_CLASS_NAME_KEY);
        Preconditions.checkNotNull((Object)this.algorithmClassName, (String)"The props `%s` cannot be null when uses class based sharding strategy.", (Object)ALGORITHM_CLASS_NAME_KEY);
        this.createAlgorithmInstance();
    }

    private void createAlgorithmInstance() {
        switch (this.strategy) {
            case STANDARD: {
                this.standardShardingAlgorithm = ClassBasedShardingAlgorithmFactory.newInstance(this.algorithmClassName, StandardShardingAlgorithm.class);
                break;
            }
            case COMPLEX: {
                this.complexKeysShardingAlgorithm = ClassBasedShardingAlgorithmFactory.newInstance(this.algorithmClassName, ComplexKeysShardingAlgorithm.class);
                break;
            }
            case HINT: {
                this.hintShardingAlgorithm = ClassBasedShardingAlgorithmFactory.newInstance(this.algorithmClassName, HintShardingAlgorithm.class);
                break;
            }
        }
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        return this.standardShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        return this.standardShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, ComplexKeysShardingValue<Comparable<?>> shardingValue) {
        return this.complexKeysShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, HintShardingValue<Comparable<?>> shardingValue) {
        return this.hintShardingAlgorithm.doSharding(availableTargetNames, shardingValue);
    }

    public String getType() {
        return "CLASS_BASED";
    }

    @Generated
    public ClassBasedShardingAlgorithmStrategyType getStrategy() {
        return this.strategy;
    }

    @Generated
    public String getAlgorithmClassName() {
        return this.algorithmClassName;
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

