/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.segment.orderby.item;

import java.util.Objects;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.optimize.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sql.parser.sql.common.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ColumnOrderByItemConverter
implements SQLSegmentConverter<ColumnOrderByItemSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(ColumnOrderByItemSegment segment) {
        Optional<SqlNode> result = new ColumnConverter().convertToSQLNode(segment.getColumn()).map(optional -> optional);
        if (result.isPresent() && Objects.equals(OrderDirection.DESC, segment.getOrderDirection())) {
            result = Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.DESC, new SqlNode[]{result.get()}, SqlParserPos.ZERO));
        }
        return result;
    }

    @Override
    public Optional<ColumnOrderByItemSegment> convertToSQLSegment(SqlNode sqlNode) {
        if (!(sqlNode instanceof SqlIdentifier)) {
            return Optional.empty();
        }
        SqlIdentifier sqlIdentifier = (SqlIdentifier)sqlNode;
        if (sqlIdentifier.names.size() > 1) {
            SqlIdentifier column = sqlIdentifier.getComponent(1);
            SqlIdentifier owner = sqlIdentifier.getComponent(0);
            ColumnSegment columnSegment = new ColumnSegment(this.getStartIndex((SqlNode)sqlIdentifier), this.getStopIndex((SqlNode)sqlIdentifier), new IdentifierValue(column.toString()));
            columnSegment.setOwner(new OwnerSegment(this.getStartIndex((SqlNode)owner), this.getStopIndex((SqlNode)owner), new IdentifierValue(owner.toString())));
            return Optional.of(new ColumnOrderByItemSegment(columnSegment, OrderDirection.ASC));
        }
        ColumnSegment columnSegment = new ColumnSegment(this.getStartIndex((SqlNode)sqlIdentifier), this.getStopIndex((SqlNode)sqlIdentifier), new IdentifierValue((String)sqlIdentifier.names.get(0)));
        return Optional.of(new ColumnOrderByItemSegment(columnSegment, OrderDirection.ASC));
    }
}

