/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.generic;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLCommandCompletePacket
implements PostgreSQLIdentifierPacket {
    private static final Collection<String> TAGS_WITH_COUNT = new HashSet<String>(Arrays.asList("INSERT", "SELECT", "UPDATE", "DELETE"));
    private final String sqlCommand;
    private final long rowCount;

    public void write(PostgreSQLPacketPayload payload) {
        if (!TAGS_WITH_COUNT.contains(this.sqlCommand)) {
            payload.writeStringNul(this.sqlCommand);
            return;
        }
        String delimiter = "INSERT".equals(this.sqlCommand) ? " 0 " : " ";
        payload.writeStringNul(String.join((CharSequence)delimiter, this.sqlCommand, Long.toString(this.rowCount)));
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLMessagePacketType.COMMAND_COMPLETE;
    }

    @Generated
    public PostgreSQLCommandCompletePacket(String sqlCommand, long rowCount) {
        this.sqlCommand = sqlCommand;
        this.rowCount = rowCount;
    }
}

