/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComParsePacket
extends PostgreSQLCommandPacket {
    private final String statementId;
    private final String sql;
    private final List<PostgreSQLBinaryColumnType> binaryStatementColumnTypes;

    public PostgreSQLComParsePacket(PostgreSQLPacketPayload payload) {
        payload.readInt4();
        this.statementId = payload.readStringNul();
        this.sql = this.alterSQLToJDBCStyle(payload.readStringNul());
        this.binaryStatementColumnTypes = this.sql.isEmpty() ? Collections.emptyList() : this.getParameterTypes(payload);
    }

    private List<PostgreSQLBinaryColumnType> getParameterTypes(PostgreSQLPacketPayload payload) {
        int parameterCount = payload.readInt2();
        ArrayList<PostgreSQLBinaryColumnType> result = new ArrayList<PostgreSQLBinaryColumnType>(parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            result.add(PostgreSQLBinaryColumnType.valueOf(payload.readInt4()));
        }
        return result;
    }

    private String alterSQLToJDBCStyle(String sql) {
        return sql.replaceAll("\\$[0-9]+", "?");
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLCommandPacketType.PARSE_COMMAND;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<PostgreSQLBinaryColumnType> getBinaryStatementColumnTypes() {
        return this.binaryStatementColumnTypes;
    }

    @Generated
    public String toString() {
        return "PostgreSQLComParsePacket(statementId=" + this.getStatementId() + ", sql=" + this.getSql() + ", binaryStatementColumnTypes=" + this.getBinaryStatementColumnTypes() + ")";
    }
}

