/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.protocol;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public final class PostgreSQLArrayParameterDecoder {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public short[] decodeInt2Array(byte[] parameterBytes, boolean isBinary) {
        if (!isBinary) {
            String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
            Collection<String> parameterElements = this.decodeText(parameterValue);
            short[] result = new short[parameterElements.size()];
            int index = 0;
            for (String element : parameterElements) {
                result[index++] = Short.parseShort(element);
            }
            return result;
        }
        throw new UnsupportedOperationException("binary mode");
    }

    public int[] decodeInt4Array(byte[] parameterBytes, boolean isBinary) {
        if (!isBinary) {
            String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
            Collection<String> parameterElements = this.decodeText(parameterValue);
            int[] result = new int[parameterElements.size()];
            int index = 0;
            for (String element : parameterElements) {
                result[index++] = Integer.parseInt(element);
            }
            return result;
        }
        throw new UnsupportedOperationException("binary mode");
    }

    public long[] decodeInt8Array(byte[] parameterBytes, boolean isBinary) {
        if (!isBinary) {
            String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
            Collection<String> parameterElements = this.decodeText(parameterValue);
            long[] result = new long[parameterElements.size()];
            int index = 0;
            for (String element : parameterElements) {
                result[index++] = Long.parseLong(element);
            }
            return result;
        }
        throw new UnsupportedOperationException("binary mode");
    }

    public float[] decodeFloat4Array(byte[] parameterBytes, boolean isBinary) {
        if (!isBinary) {
            String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
            Collection<String> parameterElements = this.decodeText(parameterValue);
            float[] result = new float[parameterElements.size()];
            int index = 0;
            for (String element : parameterElements) {
                result[index++] = Float.parseFloat(element);
            }
            return result;
        }
        throw new UnsupportedOperationException("binary mode");
    }

    public double[] decodeFloat8Array(byte[] parameterBytes, boolean isBinary) {
        if (!isBinary) {
            String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
            Collection<String> parameterElements = this.decodeText(parameterValue);
            double[] result = new double[parameterElements.size()];
            int index = 0;
            for (String element : parameterElements) {
                result[index++] = Double.parseDouble(element);
            }
            return result;
        }
        throw new UnsupportedOperationException("binary mode");
    }

    public boolean[] decodeBoolArray(byte[] parameterBytes, boolean isBinary) {
        if (!isBinary) {
            String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
            Collection<String> parameterElements = this.decodeText(parameterValue);
            boolean[] result = new boolean[parameterElements.size()];
            int index = 0;
            for (String element : parameterElements) {
                result[index++] = Boolean.parseBoolean(element);
            }
            return result;
        }
        throw new UnsupportedOperationException("binary mode");
    }

    public String[] decodeStringArray(byte[] parameterBytes, boolean isBinary) {
        if (!isBinary) {
            String parameterValue = new String(parameterBytes, StandardCharsets.UTF_8);
            Collection<String> parameterElements = this.decodeText(parameterValue);
            return parameterElements.toArray(EMPTY_STRING_ARRAY);
        }
        throw new UnsupportedOperationException("binary mode");
    }

    private Collection<String> decodeText(String value) {
        if (value.length() < 2) {
            throw new IllegalArgumentException("value length less than 2");
        }
        if ('{' != value.charAt(0) || '}' != value.charAt(value.length() - 1)) {
            throw new IllegalArgumentException("value not start with '{' or not end with '}'");
        }
        String[] elements = value.substring(1, value.length() - 1).split(",");
        return Arrays.stream(elements).map(each -> {
            if ("NULL".equals(each)) {
                return null;
            }
            if ('\"' == each.charAt(0) && '\"' == each.charAt(each.length() - 1)) {
                each = each.substring(1, each.length() - 1);
            }
            while (each.contains("\\\"")) {
                each = each.replace("\\\"", "\"");
            }
            while (each.contains("\\\\")) {
                each = each.replace("\\\\", "\\");
            }
            return each;
        }).collect(Collectors.toCollection(ArrayList::new));
    }
}

