/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLValueFormat;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatement;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatementRegistry;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.PostgreSQLTypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLComBindPacket
extends PostgreSQLCommandPacket {
    private final PostgreSQLPacketPayload payload;
    private final String portal;
    private final String statementId;
    private final List<Object> parameters;
    private final List<PostgreSQLValueFormat> resultFormats;

    public PostgreSQLComBindPacket(PostgreSQLPacketPayload payload, int connectionId) {
        this.payload = payload;
        payload.readInt4();
        this.portal = payload.readStringNul();
        this.statementId = payload.readStringNul();
        int parameterFormatCount = payload.readInt2();
        ArrayList<Integer> parameterFormats = new ArrayList<Integer>(parameterFormatCount);
        for (int i = 0; i < parameterFormatCount; ++i) {
            parameterFormats.add(payload.readInt2());
        }
        PostgreSQLBinaryStatement binaryStatement = PostgreSQLBinaryStatementRegistry.getInstance().get(connectionId, this.statementId);
        this.parameters = binaryStatement.getSql().isEmpty() ? Collections.emptyList() : this.getParameters(payload, parameterFormats, binaryStatement.getColumnTypes());
        int resultFormatsLength = payload.readInt2();
        this.resultFormats = new ArrayList<PostgreSQLValueFormat>(resultFormatsLength);
        for (int i = 0; i < resultFormatsLength; ++i) {
            this.resultFormats.add(PostgreSQLValueFormat.valueOf(payload.readInt2()));
        }
    }

    private List<Object> getParameters(PostgreSQLPacketPayload payload, List<Integer> parameterFormats, List<PostgreSQLBinaryColumnType> columnTypes) {
        int parameterCount = payload.readInt2();
        ArrayList<Object> result = new ArrayList<Object>(parameterCount);
        for (int parameterIndex = 0; parameterIndex < parameterCount; ++parameterIndex) {
            int parameterValueLength = payload.readInt4();
            if (-1 == parameterValueLength) {
                result.add(null);
                continue;
            }
            Object parameterValue = this.isTextParameterValue(parameterFormats, parameterIndex) ? this.getTextParameters(payload, parameterValueLength, columnTypes.get(parameterIndex)) : this.getBinaryParameters(payload, parameterValueLength, columnTypes.get(parameterIndex));
            result.add(parameterValue);
        }
        return result;
    }

    private boolean isTextParameterValue(List<Integer> parameterFormats, int parameterIndex) {
        if (parameterFormats.isEmpty()) {
            return true;
        }
        if (1 == parameterFormats.size()) {
            return 0 == parameterFormats.get(0);
        }
        return 0 == parameterFormats.get(parameterIndex);
    }

    private Object getTextParameters(PostgreSQLPacketPayload payload, int parameterValueLength, PostgreSQLBinaryColumnType columnType) {
        byte[] bytes = new byte[parameterValueLength];
        payload.getByteBuf().readBytes(bytes);
        return this.getTextParameters(new String(bytes), columnType);
    }

    private Object getTextParameters(String textValue, PostgreSQLBinaryColumnType columnType) {
        switch (columnType) {
            case POSTGRESQL_TYPE_UNSPECIFIED: {
                return new PostgreSQLTypeUnspecifiedSQLParameter(textValue);
            }
            case POSTGRESQL_TYPE_BOOL: {
                return Boolean.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_INT2: 
            case POSTGRESQL_TYPE_INT4: {
                return Integer.parseInt(textValue);
            }
            case POSTGRESQL_TYPE_INT8: {
                return Long.parseLong(textValue);
            }
            case POSTGRESQL_TYPE_FLOAT4: {
                return Float.valueOf(Float.parseFloat(textValue));
            }
            case POSTGRESQL_TYPE_FLOAT8: {
                return Double.parseDouble(textValue);
            }
            case POSTGRESQL_TYPE_NUMERIC: {
                try {
                    return Integer.parseInt(textValue);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Long.parseLong(textValue);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        return new BigDecimal(textValue);
                    }
                }
            }
            case POSTGRESQL_TYPE_DATE: {
                return Date.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_TIME: {
                return Time.valueOf(textValue);
            }
            case POSTGRESQL_TYPE_TIMESTAMP: 
            case POSTGRESQL_TYPE_TIMESTAMPTZ: {
                return Timestamp.valueOf(textValue);
            }
        }
        return textValue;
    }

    private Object getBinaryParameters(PostgreSQLPacketPayload payload, int parameterValueLength, PostgreSQLBinaryColumnType columnType) {
        PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue(columnType);
        return binaryProtocolValue.read(payload, parameterValueLength);
    }

    public void write(PostgreSQLPacketPayload payload) {
    }

    @Override
    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLCommandPacketType.BIND_COMMAND;
    }

    @Generated
    public PostgreSQLPacketPayload getPayload() {
        return this.payload;
    }

    @Generated
    public String getPortal() {
        return this.portal;
    }

    @Generated
    public String getStatementId() {
        return this.statementId;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public List<PostgreSQLValueFormat> getResultFormats() {
        return this.resultFormats;
    }

    @Generated
    public String toString() {
        return "PostgreSQLComBindPacket(payload=" + this.getPayload() + ", portal=" + this.getPortal() + ", statementId=" + this.getStatementId() + ", parameters=" + this.getParameters() + ", resultFormats=" + this.getResultFormats() + ")";
    }
}

