/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.binary.PostgreSQLBinaryStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;

public final class PostgreSQLBinaryStatementRegistry {
    private static final PostgreSQLBinaryStatementRegistry INSTANCE = new PostgreSQLBinaryStatementRegistry();
    private final ConcurrentMap<Integer, PostgreSQLConnectionBinaryStatementRegistry> connectionBinaryStatements = new ConcurrentHashMap<Integer, PostgreSQLConnectionBinaryStatementRegistry>(65535, 1.0f);

    public static PostgreSQLBinaryStatementRegistry getInstance() {
        return INSTANCE;
    }

    public void register(int connectionId) {
        this.connectionBinaryStatements.put(connectionId, new PostgreSQLConnectionBinaryStatementRegistry());
    }

    public void register(int connectionId, String statementId, String sql, SQLStatement sqlStatement, List<PostgreSQLBinaryColumnType> binaryColumnTypes) {
        ((PostgreSQLConnectionBinaryStatementRegistry)this.connectionBinaryStatements.get(connectionId)).getBinaryStatements().put(statementId, new PostgreSQLBinaryStatement(sql, sqlStatement, binaryColumnTypes));
    }

    public PostgreSQLBinaryStatement get(int connectionId, String statementId) {
        return ((PostgreSQLConnectionBinaryStatementRegistry)this.connectionBinaryStatements.get(connectionId)).binaryStatements.getOrDefault(statementId, new PostgreSQLBinaryStatement("", (SQLStatement)new EmptyStatement(), Collections.emptyList()));
    }

    public void unregister(int connectionId) {
        this.connectionBinaryStatements.remove(connectionId);
    }

    public void unregister(int connectionId, String statementId) {
        if (this.connectionBinaryStatements.containsKey(connectionId)) {
            ((PostgreSQLConnectionBinaryStatementRegistry)this.connectionBinaryStatements.get(connectionId)).getBinaryStatements().remove(statementId);
        }
    }

    private final class PostgreSQLConnectionBinaryStatementRegistry {
        private final ConcurrentMap<String, PostgreSQLBinaryStatement> binaryStatements = new ConcurrentHashMap<String, PostgreSQLBinaryStatement>(65535, 1.0f);

        private PostgreSQLConnectionBinaryStatementRegistry() {
        }

        @Generated
        public ConcurrentMap<String, PostgreSQLBinaryStatement> getBinaryStatements() {
            return this.binaryStatements;
        }
    }
}

