/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLErrorCode;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLMessageSeverityLevel;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLErrorResponsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLPacketCodecEngine
implements DatabasePacketCodecEngine<PostgreSQLPacket> {
    private static final int MESSAGE_TYPE_LENGTH = 1;
    private static final int PAYLOAD_LENGTH = 4;

    public boolean isValidHeader(int readableBytes) {
        return readableBytes >= 5;
    }

    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        while (this.isValidHeader(in.readableBytes())) {
            int messageTypeLength = 0;
            if (0 == in.markReaderIndex().readByte()) {
                in.resetReaderIndex();
            } else {
                messageTypeLength = 1;
            }
            int remainPayloadLength = in.readInt() - 4;
            if (in.readableBytes() < remainPayloadLength) {
                in.resetReaderIndex();
                return;
            }
            in.resetReaderIndex();
            out.add(in.readRetainedSlice(messageTypeLength + 4 + remainPayloadLength));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(ChannelHandlerContext context, PostgreSQLPacket message, ByteBuf out) {
        boolean isPostgreSQLIdentifierPacket = message instanceof PostgreSQLIdentifierPacket;
        if (isPostgreSQLIdentifierPacket) {
            this.prepareMessageHeader(out, ((PostgreSQLIdentifierPacket)message).getIdentifier().getValue());
        }
        PostgreSQLPacketPayload payload = new PostgreSQLPacketPayload(out, (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        try {
            message.write(payload);
        }
        catch (Exception ex) {
            payload.getByteBuf().resetWriterIndex();
            PostgreSQLErrorResponsePacket errorResponsePacket = PostgreSQLErrorResponsePacket.newBuilder(PostgreSQLMessageSeverityLevel.ERROR, PostgreSQLErrorCode.SYSTEM_ERROR, ex.getMessage()).build();
            isPostgreSQLIdentifierPacket = true;
            this.prepareMessageHeader(out, errorResponsePacket.getIdentifier().getValue());
            errorResponsePacket.write(payload);
        }
        finally {
            if (isPostgreSQLIdentifierPacket) {
                this.updateMessageLength(out);
            }
        }
    }

    private void prepareMessageHeader(ByteBuf out, char type) {
        out.writeByte((int)type);
        out.writeInt(0);
    }

    private void updateMessageLength(ByteBuf out) {
        out.setInt(1, out.readableBytes() - 1);
    }

    public PostgreSQLPacketPayload createPacketPayload(ByteBuf message, Charset charset) {
        return new PostgreSQLPacketPayload(message, charset);
    }
}

