/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.node;

import com.google.common.base.Joiner;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class CacheNode {
    private static final String CACHE_NODE = "cache";
    private static final String PATH_SEPARATOR = "/";

    public static Optional<String> getCacheId(String path, String cachePath) {
        Pattern pattern = Pattern.compile(CacheNode.getCacheNodePath(path) + "/(\\w+)?", 2);
        Matcher matcher = pattern.matcher(cachePath);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    private static String getCacheId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getCachePath(String path, String cacheId) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)CacheNode.getCacheNodePath(path), (Object)cacheId, new Object[0]);
    }

    public static String getCachePath(String path) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)CacheNode.getCacheNodePath(path), (Object)CacheNode.getCacheId(), new Object[0]);
    }

    private static String getCacheNodePath(String path) {
        return Joiner.on((String)PATH_SEPARATOR).join((Object)path, (Object)CACHE_NODE, new Object[0]);
    }

    @Generated
    private CacheNode() {
    }
}

