/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.subscriber;

import com.google.common.eventbus.Subscribe;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.schema.QualifiedSchema;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node.StorageStatusNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class StorageNodeStatusSubscriber {
    private final ClusterPersistRepository repository;

    public StorageNodeStatusSubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void update(DataSourceDisabledEvent event) {
        if (event.isDisabled()) {
            this.repository.persist(StorageStatusNode.getStatusPath(StorageNodeStatus.DISABLE, new QualifiedSchema(event.getSchemaName(), event.getDataSourceName())), "");
        } else {
            this.repository.delete(StorageStatusNode.getStatusPath(StorageNodeStatus.DISABLE, new QualifiedSchema(event.getSchemaName(), event.getDataSourceName())));
        }
    }

    @Subscribe
    public void update(PrimaryDataSourceChangedEvent event) {
        this.repository.persist(StorageStatusNode.getStatusPath(StorageNodeStatus.PRIMARY, new QualifiedSchema(event.getSchemaName(), event.getGroupName())), event.getDataSourceName());
    }
}

