/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.QualifiedSchema;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.StorageNodeStatus;

public final class StorageStatusNode {
    private static final String STORAGE_NODES = "storage_nodes";

    public static String getRootPath() {
        return String.join((CharSequence)"/", "", "status", STORAGE_NODES);
    }

    public static String getStatusPath(StorageNodeStatus status) {
        return String.join((CharSequence)"/", "", "status", STORAGE_NODES, status.name().toLowerCase());
    }

    public static String getStatusPath(StorageNodeStatus status, QualifiedSchema schema) {
        return String.join((CharSequence)"/", "", "status", STORAGE_NODES, status.name().toLowerCase(), schema.toString());
    }

    public static Optional<QualifiedSchema> extractQualifiedSchema(StorageNodeStatus status, String storageNodePath) {
        Pattern pattern = Pattern.compile(StorageStatusNode.getRootPath() + "/" + status.name().toLowerCase() + "/(\\S+)$", 2);
        Matcher matcher = pattern.matcher(storageNodePath);
        return matcher.find() ? Optional.of(new QualifiedSchema(matcher.group(1))) : Optional.empty();
    }

    @Generated
    private StorageStatusNode() {
    }
}

