/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.watcher;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlSchema;
import org.apache.shardingsphere.infra.yaml.schema.swapper.SchemaYamlSwapper;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationCachedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.SchemaChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.CacheNode;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class MetaDataChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(SchemaMetaDataNode.getMetaDataNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        String schemaName = SchemaMetaDataNode.getSchemaNameBySchemaPath((String)event.getKey());
        if (!Strings.isNullOrEmpty((String)schemaName)) {
            return this.buildGovernanceEvent(schemaName, event);
        }
        if (DataChangedEvent.Type.ADDED == event.getType() && !Strings.isNullOrEmpty((String)event.getValue())) {
            schemaName = SchemaMetaDataNode.getSchemaName((String)event.getKey());
            Optional<String> ruleCacheId = this.getRuleCacheId(schemaName, event.getKey());
            return ruleCacheId.isPresent() ? Optional.of(new RuleConfigurationCachedEvent(ruleCacheId.get(), schemaName)) : Optional.empty();
        }
        if (DataChangedEvent.Type.UPDATED == event.getType()) {
            return this.buildGovernanceEvent(event);
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> buildGovernanceEvent(String schemaName, DataChangedEvent event) {
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return Optional.of(new SchemaAddedEvent(schemaName));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new SchemaDeletedEvent(schemaName));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> buildGovernanceEvent(DataChangedEvent event) {
        String schemaName = SchemaMetaDataNode.getSchemaName((String)event.getKey());
        if (Strings.isNullOrEmpty((String)schemaName) || Strings.isNullOrEmpty((String)event.getValue())) {
            return Optional.empty();
        }
        if (this.isDataSourceChangedEvent(schemaName, event.getKey())) {
            return Optional.of(this.createDataSourceChangedEvent(schemaName, event));
        }
        if (this.isRuleChangedEvent(schemaName, event.getKey())) {
            return Optional.of(this.createRuleChangedEvent(schemaName, event));
        }
        if (this.isSchemaChangedEvent(schemaName, event.getKey())) {
            return Optional.of(this.createSchemaChangedEvent(schemaName, event));
        }
        return Optional.empty();
    }

    private boolean isDataSourceChangedEvent(String schemaName, String eventPath) {
        return SchemaMetaDataNode.getMetaDataDataSourcePath((String)schemaName).equals(eventPath);
    }

    private DataSourceChangedEvent createDataSourceChangedEvent(String schemaName, DataChangedEvent event) {
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)event.getValue(), Map.class);
        HashMap<String, DataSourceConfiguration> dataSourceConfigs = yamlDataSources.isEmpty() ? new HashMap<String, DataSourceConfiguration>() : (Map)yamlDataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new YamlDataSourceConfigurationSwapper().swapToDataSourceConfiguration((Map)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return new DataSourceChangedEvent(schemaName, dataSourceConfigs);
    }

    private boolean isRuleChangedEvent(String schemaName, String eventPath) {
        return SchemaMetaDataNode.getRulePath((String)schemaName).equals(eventPath);
    }

    private Optional<String> getRuleCacheId(String schemaName, String key) {
        return CacheNode.getCacheId((String)SchemaMetaDataNode.getRulePath((String)schemaName), (String)key);
    }

    private GovernanceEvent createRuleChangedEvent(String schemaName, DataChangedEvent event) {
        return new RuleConfigurationsChangedEvent(schemaName, this.getRuleConfigurations(event.getValue()));
    }

    private Collection<RuleConfiguration> getRuleConfigurations(String yamlContent) {
        Collection rules = Strings.isNullOrEmpty((String)yamlContent) ? new LinkedList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
        return new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(rules);
    }

    private boolean isSchemaChangedEvent(String schemaName, String key) {
        return SchemaMetaDataNode.getMetaDataSchemaPath((String)schemaName).equals(key);
    }

    private GovernanceEvent createSchemaChangedEvent(String schemaName, DataChangedEvent event) {
        return new SchemaChangedEvent(schemaName, new SchemaYamlSwapper().swapToObject((YamlSchema)YamlEngine.unmarshal((String)event.getValue(), YamlSchema.class)));
    }
}

