/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.watcher;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.props.PropertiesChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.GlobalNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class PropertiesChangedWatcher
implements GovernanceWatcher<PropertiesChangedEvent> {
    @Override
    public Collection<String> getWatchingKeys() {
        return Collections.singleton(GlobalNode.getPropsPath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Collections.singleton(DataChangedEvent.Type.UPDATED);
    }

    @Override
    public Optional<PropertiesChangedEvent> createGovernanceEvent(DataChangedEvent event) {
        return Optional.of(new PropertiesChangedEvent((Properties)YamlEngine.unmarshal((String)event.getValue(), Properties.class)));
    }
}

